<?php
// Check existing StyleScore database structure
try {
    require_once '../includes/db.php';
    echo "<h3>StyleScore Database Analysis</h3>";
    
    // Show all tables
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    echo "<h4>Existing Tables:</h4><ul>";
    foreach ($tables as $table) {
        echo "<li><strong>$table</strong>";
        
        // Show row count for each table
        try {
            $count = $pdo->query("SELECT COUNT(*) FROM `$table`")->fetchColumn();
            echo " ($count records)";
        } catch (Exception $e) {
            echo " (unable to count)";
        }
        echo "</li>";
    }
    echo "</ul>";
    
    // Check specific StyleScore tables we need
    $required_tables = ['events', 'participants', 'scores', 'judges', 'judge_scores'];
    
    foreach ($required_tables as $table) {
        if (in_array($table, $tables)) {
            echo "<h4>$table Table Structure:</h4>";
            $columns = $pdo->query("DESCRIBE `$table`")->fetchAll(PDO::FETCH_ASSOC);
            echo "<table border='1' style='border-collapse: collapse; margin-bottom: 20px;'>";
            echo "<tr style='background: #f0f0f0;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
            foreach ($columns as $col) {
                echo "<tr>";
                echo "<td><strong>{$col['Field']}</strong></td>";
                echo "<td>{$col['Type']}</td>";
                echo "<td>{$col['Null']}</td>";
                echo "<td>{$col['Key']}</td>";
                echo "<td>{$col['Default']}</td>";
                echo "<td>{$col['Extra']}</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            // Show sample data (limited)
            if ($table === 'events') {
                $sample = $pdo->query("SELECT * FROM `$table` LIMIT 3")->fetchAll(PDO::FETCH_ASSOC);
                if ($sample) {
                    echo "<h5>Sample $table Data:</h5>";
                    echo "<pre>" . print_r($sample, true) . "</pre>";
                }
            }
        } else {
            echo "<p style='color: orange;'>⚠️ <strong>$table</strong> table not found</p>";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
