<?php
// Debug summary table API styling
include 'includes/db.php';

$event_id = $_GET['event_id'] ?? 3;

echo "<h1>Debug Summary Table Styling for Event ID: $event_id</h1>";

// Check if styling exists
$stmt = $pdo->prepare("SELECT styling_data FROM result_styling WHERE event_id = ? AND config_id IS NULL LIMIT 1");
$stmt->execute([$event_id]);
$styling_row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$styling_row) {
    echo "<p style='color: red; font-weight: bold;'>NO STYLING FOUND FOR EVENT ID $event_id</p>";
    echo "<p>Configure it here: <a href='/v2/admin/results_styling.php?event_id=$event_id' target='_blank'>Configure Styling</a></p>";
} else {
    $styling = json_decode($styling_row['styling_data'], true);
    echo "<h2>✓ Styling Data Found</h2>";
    echo "<pre>" . print_r($styling, true) . "</pre>";
    
    // Get event info
    $stmt = $pdo->prepare("SELECT name, date, location FROM events WHERE id = ?");
    $stmt->execute([$event_id]);
    $event = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<h2>Event Info:</h2>";
    echo "<pre>" . print_r($event, true) . "</pre>";
    
    // Simulate header generation
    function getAbsoluteLogoUrl($logo_url) {
        if (!$logo_url) return '';
        $logo_url = preg_replace('#^\.\./#', '', $logo_url);
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'];
        return $protocol . '://' . $host . '/v2/' . ltrim($logo_url, '/');
    }
    
    $logo_sizes = ['small' => '50px', 'medium' => '80px', 'large' => '120px'];
    $logo_size = $logo_sizes[$styling['logo_size'] ?? 'medium'] ?? '80px';
    $logo_url = getAbsoluteLogoUrl($styling['logo_url'] ?? '');
    $logo_position = $styling['logo_position'] ?? 'left';
    
    echo "<h2>Logo Info:</h2>";
    echo "<p>Logo URL from DB: " . htmlspecialchars($styling['logo_url'] ?? 'NONE') . "</p>";
    echo "<p>Absolute Logo URL: " . htmlspecialchars($logo_url) . "</p>";
    echo "<p>Logo Size: $logo_size</p>";
    echo "<p>Logo Position: $logo_position</p>";
    
    if ($logo_url) {
        echo "<p><img src='$logo_url' style='max-width: $logo_size; border: 2px solid blue;'> (Logo Preview)</p>";
    }
    
    // Generate header HTML
    $header_html = '<div class="results-header" style="margin-bottom: 20px; border-bottom: 2px solid ' . htmlspecialchars($styling['primary_color'] ?? '#0d6efd') . '; padding-bottom: 15px;">';
    $header_html .= '<table width="100%" style="margin-bottom: 0;"><tr>';
    
    if ($logo_url && $logo_position === 'left') {
        $header_html .= '<td width="' . $logo_size . '" style="vertical-align: top;"><img src="' . htmlspecialchars($logo_url) . '" alt="Logo" style="max-height: ' . $logo_size . '; max-width: ' . $logo_size . ';"></td>';
    }
    
    $header_html .= '<td style="vertical-align: top; padding-left: 15px;">';
    if ($logo_url && $logo_position === 'center') {
        $header_html .= '<div style="text-align: center; margin-bottom: 10px;"><img src="' . htmlspecialchars($logo_url) . '" alt="Logo" style="max-height: ' . $logo_size . ';"></div>';
    }
    $header_html .= '<div>' . ($styling['header_content'] ?? '') . '</div>';
    if ($styling['show_event_info'] ?? true) {
        $header_html .= '<div style="color: ' . htmlspecialchars($styling['secondary_color'] ?? '#6c757d') . '; margin-top: 5px;">';
        $header_html .= '<strong>' . htmlspecialchars($event['name']) . '</strong>, ';
        $header_html .= date('F d, Y', strtotime($event['date'])) . ', ';
        $header_html .= htmlspecialchars($event['location']);
        $header_html .= '</div>';
    }
    $header_html .= '</td>';
    
    if ($logo_url && $logo_position === 'right') {
        $header_html .= '<td width="' . $logo_size . '" style="vertical-align: top; text-align: right;"><img src="' . htmlspecialchars($logo_url) . '" alt="Logo" style="max-height: ' . $logo_size . '; max-width: ' . $logo_size . ';"></td>';
    }
    
    $header_html .= '</tr></table></div>';
    
    echo "<h2>Generated Header HTML:</h2>";
    echo "<div style='border: 2px solid green; padding: 10px; background: white;'>";
    echo $header_html;
    echo "</div>";
    
    echo "<h3>Header HTML Source:</h3>";
    echo "<textarea style='width: 100%; height: 200px;'>" . htmlspecialchars($header_html) . "</textarea>";
}

echo "<hr>";
echo "<h2>Test Links:</h2>";
echo "<p><a href='/v2/api/summary_table_api.php?event_id=$event_id&category=all&format=html&stylesheet=yes' target='_blank'>View HTML with Stylesheet</a></p>";
echo "<p><a href='/v2/api/summary_table_api.php?event_id=$event_id&category=all&format=pdf&stylesheet=yes' target='_blank'>View PDF with Stylesheet</a></p>";
