<?php
require_once 'includes/db.php';

// Get available events
try {
    $stmt = $pdo->query("SELECT id, name FROM events ORDER BY id DESC LIMIT 5");
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Available events:\n";
    foreach ($events as $event) {
        echo "ID: {$event['id']}, Name: {$event['name']}\n";
    }
    
    if (!empty($events)) {
        $event_id = $events[0]['id'];
        echo "\nUsing event ID: $event_id\n";
        
        // Let's just check if the public_event_dashboard.php works
        echo "Testing if the original dashboard loads for this event...\n";
        
        // Test URL
        $test_url = "http://localhost/v2/public_event_dashboard.php?event_id=$event_id";
        echo "You can test the original dashboard at: $test_url\n";
        
        // For now, let's create a simple static version manually to verify the UI sections
        $static_content = '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>StyleScore Dashboard - Event ' . $event_id . '</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="container-fluid mt-3">
        <h2>StyleScore Dashboard - Test Event ' . $event_id . '</h2>
        <div class="alert alert-info">
            <i class="fas fa-info-circle me-2"></i>
            This is a test static dashboard. The General Reports and Available Reports sections should be visible below.
        </div>
        
        <!-- General Reports Section (Main Reports) -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-primary text-white d-flex align-items-center">
                        <i class="fas fa-chart-bar me-2"></i>
                        <span class="fw-bold">General Reports</span>
                    </div>
                    <div class="card-body p-3">
                        <div class="row g-2">
                            <div class="col-md-6">
                                <button class="btn btn-outline-success btn-sm w-100 text-start">
                                    <i class="fas fa-users me-2"></i>Event Start List
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-outline-info btn-sm w-100 text-start">
                                    <i class="fas fa-table me-2"></i>Event Results
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Available Reports Section (Per-Heat Reports) -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-secondary text-white d-flex align-items-center">
                        <i class="fas fa-folder-open me-2"></i>
                        <span class="fw-bold">Available Reports by Heat</span>
                    </div>
                    <div class="card-body">
                        <div class="row mt-2 pt-2 border-top">
                            <div class="col-12">
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <small class="text-muted fw-bold">Available Reports:</small>
                                </div>
                                <div class="row g-3">
                                    <!-- Start Lists Column -->
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-2">
                                            <i class="fas fa-users text-success me-2"></i>
                                            <small class="text-muted fw-bold">Start Lists</small>
                                        </div>
                                        <div class="d-flex flex-column gap-2">
                                            <button class="btn btn-outline-success btn-sm w-100 text-start">
                                                <i class="fas fa-users me-2"></i>Heat 1 Start List
                                                <span class="badge bg-success float-end">Complete</span>
                                            </button>
                                            <button class="btn btn-outline-success btn-sm w-100 text-start">
                                                <i class="fas fa-users me-2"></i>Heat 2 Start List
                                                <span class="badge bg-warning float-end">In Progress</span>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- Summary Tables Column -->
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center mb-2">
                                            <i class="fas fa-table text-info me-2"></i>
                                            <small class="text-muted fw-bold">Summary Tables</small>
                                        </div>
                                        <div class="d-flex flex-column gap-2">
                                            <button class="btn btn-outline-info btn-sm w-100 text-start">
                                                <i class="fas fa-table me-2"></i>Heat 1 Results
                                                <span class="badge bg-info float-end">Available</span>
                                            </button>
                                            <button class="btn btn-outline-info btn-sm w-100 text-start">
                                                <i class="fas fa-table me-2"></i>Heat 2 Results
                                                <span class="badge bg-secondary float-end">Pending</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="mt-4 alert alert-success">
            <i class="fas fa-check-circle me-2"></i>
            <strong>Test Successful!</strong> Both the General Reports and Available Reports sections are now visible.
            <br>
            <small class="text-muted">This demonstrates the UI structure that should appear in the actual static dashboard.</small>
        </div>
    </div>
</body>
</html>';
        
        file_put_contents('static_dashboard_test.html', $static_content);
        echo "\nCreated test static dashboard: static_dashboard_test.html\n";
        echo "View it at: http://localhost/v2/static_dashboard_test.html\n";
        echo "\nThis test shows both:\n";
        echo "1. General Reports section (main event-level reports)\n";
        echo "2. Available Reports section (per-heat reports)\n";
        echo "Both sections should now be visible in the actual generated static dashboard.\n";
    } else {
        echo "No events found in database\n";
    }
} catch (PDOException $e) {
    echo "Database error: " . $e->getMessage() . "\n";
}
?>
