<?php
require_once 'includes/db.php';

echo "Scoring Format for Event 6:\n";
echo "===========================\n";

// Get event info
$stmt = $pdo->prepare("SELECT * FROM events WHERE event_id = 6");
$stmt->execute();
$event = $stmt->fetch(PDO::FETCH_ASSOC);

echo "Event: {$event['event_name']}\n";
echo "Scoring Format ID: {$event['scoring_format_id']}\n\n";

// Get scoring format
$stmt = $pdo->prepare("SELECT * FROM scoring_formats WHERE format_id = ?");
$stmt->execute([$event['scoring_format_id']]);
$format = $stmt->fetch(PDO::FETCH_ASSOC);

echo "Format Name: {$format['format_name']}\n";
echo "Aggregation Method: {$format['aggregation_method']}\n";
echo "Scale Type: {$format['scale_type']}\n";
echo "Max Value: {$format['max_value']}\n";
echo "Min Value: {$format['min_value']}\n";
echo "Precision Decimal: {$format['precision_decimal']}\n";
