<?php
/**
 * Test Judge Status API with Heat/Run numbers
 */

echo "=== Judge Status API Test (with heat/run) ===\n\n";

$base_url = 'http://localhost/v2/api/judge_status_api.php';
$test_event_id = 6;
$test_judge_id = 1;

echo "Testing with Event ID: $test_event_id, Judge ID: $test_judge_id\n\n";

// Test: Update judge status with heat and run
echo "TEST: Update judge status with heat 2, run 3\n";
$data = [
    'event_id' => $test_event_id,
    'judge_id' => $test_judge_id,
    'status' => 'ready',
    'heat_number' => 2,
    'run_number' => 3,
    'timestamp' => date('Y-m-d H:i:s')
];

$options = [
    'http' => [
        'header'  => "Content-Type: application/json\r\n",
        'method'  => 'POST',
        'content' => json_encode($data)
    ]
];
$context  = stream_context_create($options);
$response = file_get_contents($base_url, false, $context);

$result = json_decode($response, true);
echo "Response: " . json_encode($result, JSON_PRETTY_PRINT) . "\n\n";

// Verify the data was saved
echo "Verifying data in database...\n";
require_once 'includes/db.php';
$stmt = $pdo->prepare("SELECT * FROM judge_assignments WHERE event_id = ? AND judge_id = ?");
$stmt->execute([$test_event_id, $test_judge_id]);
$assignment = $stmt->fetch(PDO::FETCH_ASSOC);

if ($assignment) {
    echo "Database record:\n";
    echo "  Status: " . $assignment['status'] . "\n";
    echo "  Heat Number: " . ($assignment['heat_number'] ?? 'NULL') . "\n";
    echo "  Run Number: " . ($assignment['run_number'] ?? 'NULL') . "\n";
    echo "  Updated At: " . ($assignment['status_updated_at'] ?? 'NULL') . "\n";
} else {
    echo "No assignment found!\n";
}

echo "\n=== Test Completed ===\n";
