<?php
// Quick test for figure loading
try {
    include 'includes/db_connect.php';
    
    echo "<h3>Database Connection Test</h3>\n";
    echo "Connected successfully<br>\n";
    
    // Test event 3
    echo "<h3>Event 3 Details</h3>\n";
    $event_stmt = $pdo->prepare('SELECT * FROM events WHERE id = 3');
    $event_stmt->execute();
    $event = $event_stmt->fetch(PDO::FETCH_ASSOC);
    if ($event) {
        echo "Sport: " . htmlspecialchars($event['sport_discipline']) . "<br>\n";
        echo "Name: " . htmlspecialchars($event['event_name']) . "<br>\n";
    } else {
        echo "Event 3 not found<br>\n";
    }
    
    // Test available sports
    echo "<h3>Available Sports in figure_sports</h3>\n";
    $sports_stmt = $pdo->query('SELECT sport_name FROM figure_sports ORDER BY sport_name');
    while ($row = $sports_stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "- " . htmlspecialchars($row['sport_name']) . "<br>\n";
    }
    
    // Test categories for snowboard_big_air_best_two
    echo "<h3>Categories for snowboard_big_air_best_two</h3>\n";
    $cat_stmt = $pdo->prepare('SELECT category_name FROM figure_categories WHERE sport_name = ? AND is_active = 1 ORDER BY sort_order, category_name');
    $cat_stmt->execute(['snowboard_big_air_best_two']);
    $categories = [];
    while ($row = $cat_stmt->fetch(PDO::FETCH_ASSOC)) {
        $categories[] = $row['category_name'];
        echo "- " . htmlspecialchars($row['category_name']) . "<br>\n";
    }
    
    if (empty($categories)) {
        echo "No categories found for snowboard_big_air_best_two<br>\n";
        
        // Try to find similar sport names
        echo "<h4>Similar sport names:</h4>\n";
        $similar_stmt = $pdo->prepare("SELECT DISTINCT sport_name FROM figure_categories WHERE sport_name LIKE '%snowboard%' OR sport_name LIKE '%big_air%'");
        $similar_stmt->execute();
        while ($row = $similar_stmt->fetch(PDO::FETCH_ASSOC)) {
            echo "- " . htmlspecialchars($row['sport_name']) . "<br>\n";
        }
    }
    
    // Test items for snowboard_big_air_best_two
    echo "<h3>Items for snowboard_big_air_best_two</h3>\n";
    $items_stmt = $pdo->prepare('SELECT category_name, item_name FROM figure_items WHERE sport_name = ? AND is_active = 1 ORDER BY category_name, sort_order, item_name');
    $items_stmt->execute(['snowboard_big_air_best_two']);
    $items = [];
    while ($row = $items_stmt->fetch(PDO::FETCH_ASSOC)) {
        $items[] = $row;
        echo "- " . htmlspecialchars($row['category_name']) . " -> " . htmlspecialchars($row['item_name']) . "<br>\n";
    }
    
    if (empty($items)) {
        echo "No items found for snowboard_big_air_best_two<br>\n";
    }
    
} catch (Exception $e) {
    echo "<h3>Error</h3>\n";
    echo "Error: " . htmlspecialchars($e->getMessage()) . "<br>\n";
    echo "File: " . htmlspecialchars($e->getFile()) . "<br>\n";
    echo "Line: " . $e->getLine() . "<br>\n";
}
?>
