<?php
include_once 'includes/db.php';

$event_id = 6;

echo "<pre>";
echo "=== TESTING EVENT QUERY ===\n\n";

// Test 1: Simple select all
$stmt1 = $pdo->prepare("SELECT * FROM events WHERE id = ?");
$stmt1->execute([$event_id]);
$result1 = $stmt1->fetch(PDO::FETCH_ASSOC);

echo "Test 1: SELECT * FROM events\n";
echo "Columns returned: " . count($result1) . "\n";
echo "Columns: " . implode(", ", array_keys($result1)) . "\n\n";
echo "scoring_format value: '" . ($result1['scoring_format'] ?? 'NOT FOUND') . "'\n\n";

// Test 2: With JOINs
$stmt2 = $pdo->prepare("
    SELECT e.*,
           sf.name as format_name, sf.mode as format_mode
    FROM events e
    LEFT JOIN scoring_formats sf ON e.scoring_format = sf.format_id
    WHERE e.id = ?
");
$stmt2->execute([$event_id]);
$result2 = $stmt2->fetch(PDO::FETCH_ASSOC);

echo "Test 2: SELECT e.* with LEFT JOIN\n";
echo "Columns returned: " . count($result2) . "\n";
echo "Columns: " . implode(", ", array_keys($result2)) . "\n\n";
echo "scoring_format value: '" . ($result2['scoring_format'] ?? 'NOT FOUND') . "'\n";
echo "format_name value: '" . ($result2['format_name'] ?? 'NOT FOUND') . "'\n\n";

// Test 3: Check table structure
$stmt3 = $pdo->query("DESCRIBE events");
$columns = $stmt3->fetchAll(PDO::FETCH_ASSOC);

echo "Test 3: DESCRIBE events table\n";
echo "Total columns in table: " . count($columns) . "\n";
foreach ($columns as $col) {
    echo "  - " . $col['Field'] . " (" . $col['Type'] . ")\n";
}

echo "</pre>";
?>
