<?php
include 'includes/db.php';

$event_id = 6;

echo "=== Testing Event Query ===\n\n";

$event_stmt = $pdo->prepare("
    SELECT e.*, 
           sf.name as format_name, sf.mode as format_mode,
           fsd.icon_path as sport_icon_path, fsd.short_name as sport_short_name
    FROM events e
    LEFT JOIN scoring_formats sf ON e.scoring_format = sf.format_id
    LEFT JOIN figure_sports fs ON LOWER(e.sport_discipline) = LOWER(fs.sport_name)
    LEFT JOIN figure_sport_details fsd ON fs.id = fsd.sport_id
    WHERE e.id = ?
");
$event_stmt->execute([$event_id]);
$event = $event_stmt->fetch(PDO::FETCH_ASSOC);

echo "Event ID: " . ($event['id'] ?? 'NULL') . "\n";
echo "Event Name: " . ($event['name'] ?? 'NULL') . "\n";
echo "scoring_format column value: '" . ($event['scoring_format'] ?? 'NULL') . "'\n";
echo "Length of scoring_format: " . strlen($event['scoring_format'] ?? '') . "\n";
echo "\n";

// Check for trailing spaces or special characters
if (isset($event['scoring_format'])) {
    echo "Hex dump: " . bin2hex($event['scoring_format']) . "\n";
    echo "Trimmed value: '" . trim($event['scoring_format']) . "'\n";
    echo "Empty check: " . (empty($event['scoring_format']) ? 'EMPTY' : 'NOT EMPTY') . "\n";
}

// Also check direct query
echo "\n=== Direct Query ===\n";
$direct = $pdo->prepare("SELECT scoring_format FROM events WHERE id = ?");
$direct->execute([$event_id]);
$result = $direct->fetch(PDO::FETCH_ASSOC);
echo "Direct scoring_format: '" . ($result['scoring_format'] ?? 'NULL') . "'\n";
