<?php
require_once 'includes/db.php';

$event_id = 6;
$heat_number = 1;

echo "=== PARTICIPANTS IN EVENT 6, HEAT 1 ===\n\n";
$stmt = $pdo->prepare("
    SELECT 
        ep.id,
        p.bib_number,
        p.first_name,
        p.last_name,
        ep.category,
        ep.category_id,
        ep.heat_number,
        ec.category_name
    FROM event_participants ep
    JOIN participants p ON ep.participant_id = p.id
    LEFT JOIN event_categories ec ON ep.category_id = ec.id
    WHERE ep.event_id = ? AND ep.heat_number = ?
    ORDER BY p.bib_number
");
$stmt->execute([$event_id, $heat_number]);
$participants = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($participants as $p) {
    echo "BIB {$p['bib_number']}: {$p['first_name']} {$p['last_name']}\n";
    echo "  Category (old): {$p['category']}\n";
    echo "  Category ID: {$p['category_id']}\n";
    echo "  Category Name (from event_categories): {$p['category_name']}\n";
    echo "  Heat: {$p['heat_number']}\n\n";
}

echo "\n=== CATEGORIES IN EVENT 6 ===\n\n";
$stmt = $pdo->prepare("
    SELECT id, category_name, is_main_category
    FROM event_categories
    WHERE event_id = ?
    ORDER BY category_name
");
$stmt->execute([$event_id]);
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($categories as $cat) {
    echo "ID {$cat['id']}: {$cat['category_name']} (Main: " . ($cat['is_main_category'] ? 'Yes' : 'No') . ")\n";
}

echo "\n=== SCORES IN EVENT 6, HEAT 1 ===\n\n";
$stmt = $pdo->prepare("
    SELECT 
        p.bib_number,
        p.first_name,
        p.last_name,
        r.run_number,
        s.score_value,
        u.username as judge_name,
        s.is_approved,
        s.approved_at
    FROM event_participants ep
    JOIN participants p ON ep.participant_id = p.id
    JOIN runs r ON r.event_participant_id = ep.id
    JOIN scores s ON r.id = s.run_id
    LEFT JOIN users u ON s.judge_id = u.id
    WHERE ep.event_id = ? AND ep.heat_number = ?
    ORDER BY p.bib_number, r.run_number, u.username
");
$stmt->execute([$event_id, $heat_number]);
$scores = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($scores as $sc) {
    echo "BIB {$sc['bib_number']} ({$sc['first_name']} {$sc['last_name']}): ";
    echo "Run {$sc['run_number']}, Judge: {$sc['judge_name']}, Score: {$sc['score_value']}, ";
    echo "Approved: " . ($sc['is_approved'] ? 'Yes' : 'No') . " ({$sc['approved_at']})\n";
}

echo "\n=== TESTING API CALL ===\n\n";
$url = "http://localhost/v2/api/summary_table_api.php?event_id=$event_id&heat_number=$heat_number&category=all&format=json";
echo "URL: $url\n\n";

$context = stream_context_create([
    'http' => [
        'timeout' => 30
    ]
]);

$response = @file_get_contents($url, false, $context);
if ($response === false) {
    echo "ERROR: Could not fetch API response\n";
    $error = error_get_last();
    echo "Error: " . print_r($error, true) . "\n";
} else {
    $data = json_decode($response, true);
    
    if ($data) {
        echo "Success: " . ($data['success'] ? 'TRUE' : 'FALSE') . "\n";
        
        if (isset($data['message'])) {
            echo "Message: {$data['message']}\n";
        }
        
        if (isset($data['debug_info'])) {
            echo "\nDebug Info:\n";
            print_r($data['debug_info']);
        }
        
        if (isset($data['participants_count'])) {
            echo "\nParticipants count: {$data['participants_count']}\n";
        }
        
        if (isset($data['categories'])) {
            echo "\nCategories found in response: " . implode(', ', $data['categories']) . "\n";
        }
    } else {
        echo "ERROR: Could not decode JSON\n";
        echo "Raw response (first 1000 chars):\n";
        echo substr($response, 0, 1000) . "\n";
    }
}
