<?php
require_once 'includes/db.php';

// Check participants
$stmt = $pdo->query("SELECT COUNT(*) as count FROM event_participants WHERE event_id = 6");
$participantCount = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
echo "Participants in event 6: $participantCount\n";

// Check scores
$stmt = $pdo->query("SELECT COUNT(*) as count FROM scoring_results WHERE event_id = 6");
$scoreCount = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
echo "Scores in event 6: $scoreCount\n";

// Check scores for heat 1
$stmt = $pdo->query("SELECT COUNT(*) as count FROM scoring_results WHERE event_id = 6 AND heat_number = 1");
$heat1Count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
echo "Scores in event 6, heat 1: $heat1Count\n";

// Show some participant details
echo "\n=== PARTICIPANTS ===\n";
$stmt = $pdo->query("SELECT p.id, p.bib_number, p.first_name, p.last_name, ep.heat_number 
                     FROM participants p 
                     JOIN event_participants ep ON p.id = ep.participant_id 
                     WHERE ep.event_id = 6 
                     LIMIT 10");
while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "ID: {$row['id']}, BIB: {$row['bib_number']}, Name: {$row['first_name']} {$row['last_name']}, Heat: {$row['heat_number']}\n";
}

// Show some scores
echo "\n=== SCORES ===\n";
$stmt = $pdo->query("SELECT s.participant_id, s.heat_number, s.run_number, s.total_score, p.bib_number
                     FROM scoring_results s
                     JOIN participants p ON s.participant_id = p.id
                     WHERE s.event_id = 6 
                     LIMIT 10");
while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "Participant ID: {$row['participant_id']}, BIB: {$row['bib_number']}, Heat: {$row['heat_number']}, Run: {$row['run_number']}, Score: {$row['total_score']}\n";
}
