<?php
include 'includes/db.php';
include 'includes/ScoringLayoutConfig.php';

echo "<h1>Criteria Input Grid Layout Test</h1>";

echo "<h2>Current Configurations:</h2>";

$stmt = $pdo->query('SELECT * FROM scoring_layout_configs ORDER BY event_id');
$configs = $stmt->fetchAll();

foreach ($configs as $config) {
    $decoded_config = json_decode($config['config_json'], true);
    $criteria_setting = $decoded_config['criteria-input-grid'] ?? 'not set';
    $figures_setting = $decoded_config['figures-card'] ?? 'not set';
    
    echo "<h3>Event " . $config['event_id'] . " (Heat: " . ($config['heat_number'] ?: 'All') . ")</h3>";
    echo "<p><strong>criteria-input-grid setting:</strong> " . ($criteria_setting ? 'true (SHOW)' : 'false (HIDE)') . "</p>";
    echo "<p><strong>figures-card setting:</strong> " . ($figures_setting ? 'true (SHOW)' : 'false (HIDE)') . "</p>";
    
    // Test applying configuration
    echo "<h4>Generated JavaScript for this configuration:</h4>";
    echo "<pre>" . htmlspecialchars(ScoringLayoutConfig::generateApplyScript($decoded_config)) . "</pre>";
    echo "<hr>";
}

echo "<h2>Test Links:</h2>";
echo "<p><a href='judge/score.php?event_id=1&heat_number=1' target='_blank'>Event 1 - Should SHOW criteria-input-grid</a></p>";
echo "<p><a href='judge/score.php?event_id=3&heat_number=1' target='_blank'>Event 3 - Should HIDE criteria-input-grid</a></p>";

echo "<h2>Manual Test:</h2>";
echo "<div id='test-container'>";
echo "<div class='criteria-input-grid' style='background: #e8f5e8; padding: 20px; margin: 10px; border: 2px solid #28a745;'>";
echo "<h4>Criteria Input Grid - Test Element</h4>";
echo "<p>This represents the criteria input grid section that should be shown/hidden based on layout settings.</p>";
echo "</div>";
echo "</div>";

echo "<button onclick=\"testEvent1()\">Apply Event 1 Config (Show)</button>";
echo "<button onclick=\"testEvent3()\">Apply Event 3 Config (Hide)</button>";
echo "<button onclick=\"showElement()\">Force Show</button>";

echo "<script>";
echo "function testEvent1() {";
echo "    console.log('Testing Event 1 - Show criteria-input-grid');";
echo "    const element = document.querySelector('.criteria-input-grid');";
echo "    if (element) {";
echo "        element.style.display = 'block';";
echo "        console.log('Element shown');";
echo "    }";
echo "}";

echo "function testEvent3() {";
echo "    console.log('Testing Event 3 - Hide criteria-input-grid');";
echo "    const element = document.querySelector('.criteria-input-grid');";
echo "    if (element) {";
echo "        element.style.display = 'none';";
echo "        console.log('Element hidden');";
echo "    }";
echo "}";

echo "function showElement() {";
echo "    const element = document.querySelector('.criteria-input-grid');";
echo "    if (element) {";
echo "        element.style.display = 'block';";
echo "    }";
echo "}";
echo "</script>";
?>