<?php
// Test the API getFigures endpoint directly
header('Content-Type: text/plain');

try {
    // Database connection (same as API)
    $host = 'localhost';
    $db = 'freestyle_db';
    $user = 'root';
    $pass = '';
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";
    
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Testing API getFigures Function ===\n\n";
    
    // Include the API function
    include 'api/judge_score_api_fixed.php';
    
    // Test with scoring format 1 (if exists)
    echo "Testing with scoring_format_id=1:\n";
    $result1 = getFigures($pdo, 1, null);
    echo json_encode($result1, JSON_PRETTY_PRINT) . "\n\n";
    
    // Test with direct sport name
    echo "Testing with sport='snowboard':\n";
    $result2 = getFigures($pdo, null, 'snowboard');
    echo json_encode($result2, JSON_PRETTY_PRINT) . "\n\n";
    
    // Test with sport name that needs base extraction
    echo "Testing with sport='snowboard_big_air_best_two':\n";
    $result3 = getFigures($pdo, null, 'snowboard_big_air_best_two');
    echo json_encode($result3, JSON_PRETTY_PRINT) . "\n\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
?>
