<?php
// Simple test for the enhanced summary table API
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Testing Summary Table API Enhancement\n";
echo "=====================================\n\n";

// Test the API
$_GET['event_id'] = 3;
$_GET['format'] = 'json';

ob_start();
include 'api/summary_table_api.php';
$output = ob_get_clean();

echo "Raw output length: " . strlen($output) . " bytes\n";

// Try to decode JSON
$data = json_decode($output, true);

if (json_last_error() === JSON_ERROR_NONE) {
    echo "✓ Valid JSON response\n";
    echo "Success: " . ($data['success'] ? 'true' : 'false') . "\n";
    echo "Has participants array: " . (isset($data['participants']) ? 'true' : 'false') . "\n";
    
    if (isset($data['participants'])) {
        echo "Participants count: " . count($data['participants']) . "\n";
        
        if (count($data['participants']) > 0) {
            echo "\nFirst participant sample:\n";
            $first = $data['participants'][0];
            echo "- BIB: " . ($first['bib_number'] ?? 'N/A') . "\n";
            echo "- Name: " . ($first['participant_name'] ?? 'N/A') . "\n";
            echo "- Category: " . ($first['category'] ?? 'N/A') . "\n";
            echo "- Has heat_scores: " . (isset($first['heat_scores']) ? 'true' : 'false') . "\n";
            echo "- Has run_scores: " . (isset($first['run_scores']) ? 'true' : 'false') . "\n";
            echo "- Has judge_breakdown: " . (isset($first['judge_breakdown']) ? 'true' : 'false') . "\n";
        }
    }
    
} else {
    echo "✗ Invalid JSON: " . json_last_error_msg() . "\n";
    echo "First 500 chars of output:\n" . substr($output, 0, 500) . "\n";
}
?>
