<?php
include 'includes/db.php';

echo "<h1>Setup Events Table Layout Configuration</h1>";

try {
    // Check if scoring_layout_config column exists in events table
    $checkColumn = $pdo->query("SHOW COLUMNS FROM events LIKE 'scoring_layout_config'");
    $columnExists = $checkColumn->rowCount() > 0;
    
    if (!$columnExists) {
        echo "<p><strong>Adding scoring_layout_config column to events table...</strong></p>";
        $pdo->exec("ALTER TABLE events ADD COLUMN scoring_layout_config JSON DEFAULT NULL COMMENT 'Layout configuration for judge scoring panels'");
        echo "<p style='color: green;'>✅ Column added successfully!</p>";
    } else {
        echo "<p style='color: blue;'>ℹ️ Column scoring_layout_config already exists.</p>";
    }
    
    // Set test configurations
    echo "<h2>Setting Test Configurations:</h2>";
    
    // Event 1 - Full layout (all components visible)
    $event1Config = [
        'criteria-input-grid' => true,
        'figures-card' => true,
        'latest-scores' => true,
        'other-heat-scores' => true,
        'diversity-validation' => true,
        'figure-history' => true,
        'format-info' => true,
        'participant-selection' => true,
        'final-calculated-score' => true,
        'submit-button' => true
    ];
    
    $stmt = $pdo->prepare("UPDATE events SET scoring_layout_config = ? WHERE id = ?");
    $stmt->execute([json_encode($event1Config), 1]);
    echo "<p><strong>Event 1:</strong> Full layout configuration set ✅</p>";
    
    // Event 3 - Minimal layout (most components hidden)
    $event3Config = [
        'criteria-input-grid' => false,  // HIDE criteria input
        'figures-card' => false,         // HIDE figures
        'latest-scores' => false,        // HIDE latest scores
        'other-heat-scores' => false,    // HIDE other scores
        'diversity-validation' => false, // HIDE diversity
        'figure-history' => false,       // HIDE history
        'format-info' => false,          // HIDE format info
        'participant-selection' => true, // SHOW participant selection
        'final-calculated-score' => true, // SHOW final score
        'submit-button' => true          // SHOW submit button
    ];
    
    $stmt->execute([json_encode($event3Config), 3]);
    echo "<p><strong>Event 3:</strong> Minimal layout configuration set ✅</p>";
    
    // Show current configurations
    echo "<h2>Current Event Configurations:</h2>";
    $events = $pdo->query("SELECT id, name, scoring_layout_config FROM events WHERE id IN (1, 3)");
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>Event ID</th><th>Event Name</th><th>Layout Configuration</th></tr>";
    
    while ($event = $events->fetch()) {
        echo "<tr>";
        echo "<td>" . $event['id'] . "</td>";
        echo "<td>" . htmlspecialchars($event['name']) . "</td>";
        echo "<td>";
        
        if ($event['scoring_layout_config']) {
            $config = json_decode($event['scoring_layout_config'], true);
            echo "<div style='font-family: monospace; font-size: 12px;'>";
            foreach ($config as $component => $visible) {
                $color = $visible ? 'green' : 'red';
                $symbol = $visible ? '✅' : '❌';
                echo "<div style='color: $color;'>$symbol $component: " . ($visible ? 'SHOW' : 'HIDE') . "</div>";
            }
            echo "</div>";
        } else {
            echo "<em>No configuration set</em>";
        }
        
        echo "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h2>🧪 Test Links:</h2>";
    echo "<div style='margin: 20px 0;'>";
    echo "<a href='judge/score.php?event_id=1&heat_number=1' target='_blank' style='background: #4caf50; color: white; padding: 10px 20px; text-decoration: none; margin: 10px; border-radius: 5px;'>📊 Event 1 - Full Layout</a>";
    echo "<a href='judge/score.php?event_id=3&heat_number=1' target='_blank' style='background: #f44336; color: white; padding: 10px 20px; text-decoration: none; margin: 10px; border-radius: 5px;'>📱 Event 3 - Minimal Layout</a>";
    echo "</div>";
    
    echo "<h3>Expected Results:</h3>";
    echo "<p><strong>Event 1:</strong> Should show all components (full judge interface)</p>";
    echo "<p><strong>Event 3:</strong> Should show only participant selection, final score, and submit button</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>