<?php
if(!isset($_SESSION)) { session_start(); }

// Check if user is already logged in and redirect to appropriate dashboard
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    if ($_SESSION['user_type'] === 'admin') {
        header("Location: /v2/admin/dashboard.php");
    } elseif ($_SESSION['user_type'] === 'judge') {
        header("Location: /v2/judge/dashboard.php");
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>StyleScore - Freestyle Scoring Application</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<!-- style skin holder -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .hero-section {
            padding: 100px 0;
            color: white;
            text-align: center;
        }
        
        .hero-title {
            font-size: 4rem;
            font-weight: 700;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        
        .hero-subtitle {
            font-size: 1.5rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }
        
        .hero-description {
            font-size: 1.1rem;
            margin-bottom: 3rem;
            opacity: 0.8;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .btn-hero {
            background: rgba(255, 255, 255, 0.2);
            border: 2px solid rgba(255, 255, 255, 0.3);
            color: white;
            padding: 15px 40px;
            font-size: 1.2rem;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-hero:hover {
            background: rgba(255, 255, 255, 0.3);
            border-color: rgba(255, 255, 255, 0.5);
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
            color: white;
        }
        
        .features-section {
            background: rgba(255, 255, 255, 0.95);
            padding: 80px 0;
            backdrop-filter: blur(10px);
        }
        
        .feature-card {
            background: white;
            border-radius: 15px;
            padding: 40px 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: none;
            height: 100%;
            transition: transform 0.3s ease;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
        }
        
        .feature-icon {
            font-size: 3rem;
            color: #667eea;
            margin-bottom: 20px;
        }
        
        .feature-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 15px;
            color: #333;
        }
        
        .feature-description {
            color: #666;
            line-height: 1.6;
        }
        
        .stats-section {
            padding: 60px 0;
            color: white;
            text-align: center;
        }
        
        .stat-item {
            margin-bottom: 30px;
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: 700;
            display: block;
        }
        
        .stat-label {
            font-size: 1.1rem;
            opacity: 0.8;
        }
        
        .floating-elements {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            pointer-events: none;
        }
        
        .floating-element {
            position: absolute;
            opacity: 0.1;
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(10deg); }
        }
    </style>
</head>
<body>
    <!-- Floating Background Elements -->
    <div class="floating-elements">
        <i class="bi bi-trophy floating-element" style="top: 10%; left: 10%; font-size: 4rem; animation-delay: 0s;"></i>
        <i class="bi bi-award floating-element" style="top: 20%; right: 15%; font-size: 3rem; animation-delay: 2s;"></i>
        <i class="bi bi-star floating-element" style="top: 60%; left: 20%; font-size: 2.5rem; animation-delay: 4s;"></i>
        <i class="bi bi-gem floating-element" style="top: 70%; right: 25%; font-size: 3.5rem; animation-delay: 1s;"></i>
    </div>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <h1 class="hero-title">
                        <i class="bi bi-trophy-fill me-3"></i>
                        StyleScore
                    </h1>
                    <p class="hero-subtitle">Professional Freestyle Scoring Application</p>
                    <p class="hero-description">
                        The ultimate platform for judges and administrators to score freestyle competitions 
                        with precision, efficiency, and transparency. Built for the modern competitive landscape.
                    </p>
                    <a href="/v2/login.php" class="btn btn-hero">
                        <i class="bi bi-box-arrow-in-right me-2"></i>
                        Access Scoring System
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-12">
                    <h2 class="display-5 fw-bold text-dark mb-3">Why Choose StyleScore?</h2>
                    <p class="lead text-muted">Advanced features designed for competitive freestyle scoring</p>
                </div>
            </div>
            
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="border-0 shadow-none card feature-card text-center">
                        <div class="border-0 shadow-none card-body">
                            <i class="bi bi-speedometer2 feature-icon"></i>
                            <h5 class="feature-title">Real-Time Scoring</h5>
                            <p class="feature-description">
                                Instant score calculations and live updates ensure competitions run smoothly 
                                and participants get immediate feedback.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="border-0 shadow-none card feature-card text-center">
                        <div class="border-0 shadow-none card-body">
                            <i class="bi bi-people feature-icon"></i>
                            <h5 class="feature-title">Multi-Judge Support</h5>
                            <p class="feature-description">
                                Multiple judges can score simultaneously with automatic score aggregation 
                                and conflict resolution systems.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="border-0 shadow-none card feature-card text-center">
                        <div class="border-0 shadow-none card-body">
                            <i class="bi bi-shield-check feature-icon"></i>
                            <h5 class="feature-title">Secure & Reliable</h5>
                            <p class="feature-description">
                                Enterprise-grade security with role-based access control ensures 
                                data integrity and fair competition standards.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="container">
            <div class="row text-center">
                <div class="col-md-4">
                    <div class="stat-item">
                        <span class="stat-number">
                            <i class="bi bi-trophy-fill"></i>
                            100+
                        </span>
                        <span class="stat-label">Competitions Scored</span>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-item">
                        <span class="stat-number">
                            <i class="bi bi-people-fill"></i>
                            50+
                        </span>
                        <span class="stat-label">Certified Judges</span>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-item">
                        <span class="stat-number">
                            <i class="bi bi-award-fill"></i>
                            1000+
                        </span>
                        <span class="stat-label">Athletes Evaluated</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="text-center py-4" style="background: rgba(0,0,0,0.2); color: white;">
        <div class="container">
            <p class="mb-0">
                <i class="bi bi-c-circle me-1"></i>
                2025 StyleScore - Professional Freestyle Scoring System
            </p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>