<?php
// Include application configuration
require_once __DIR__ . '/config.php';

// Database configuration
$host = 'localhost';
$db = 'freestyle_db';
$user = 'root';
$pass = '';
$dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass);
} catch (PDOException $e) {
    die('Connection failed: ' . $e->getMessage());
}

// Include notification system configuration (PHP logic only)
require_once __DIR__ . '/notifications_config.php';
?>
<?php
if (!function_exists('btTheme')) {
  function btTheme($mode = 'nameCode') {
    $map = [
      'brite'     => 'Brite',
      'cerulean'  => 'Cerulean',
      'cosmo'     => 'Cosmo',
      'cyborg'    => 'Cyborg',
      'darkly'    => 'Darkly',
      'flatly'    => 'Flatly',
      'journal'   => 'Journal',
      'litera'    => 'Litera',
      'lumen'     => 'Lumen',
      'lux'       => 'Lux',
      'materia'   => 'Materia',
      'minty'     => 'Minty',
      'morph'     => 'Morph',
      'pulse'     => 'Pulse',
      'quartz'    => 'Quartz',
      'sandstone' => 'Sandstone',
      'simplex'   => 'Simplex',
      'sketchy'   => 'Sketchy',
      'slate'     => 'Slate',
      'solar'     => 'Solar',
      'spacelab'  => 'Spacelab',
      'superhero' => 'Superhero',
      'united'    => 'United',
      'vapor'     => 'Vapor',
      'yeti'      => 'Yeti',
      'zephyr'    => 'Zephyr'
    ];
    $code = isset($_COOKIE['ssTheme']) ? strtolower(preg_replace('/[^a-z]/', '', $_COOKIE['ssTheme'])) : 'zephyr';
    if ($mode === 'label') return $map[$code] ?? ucfirst($code);
    return $code; // 'nameCode'
  }
}

?>