<?php
/**
 * StyleScore Configuration
 * Central configuration for base URLs and application settings
 */

// Determine base URL dynamically based on server configuration
function get_base_url() {
    // Check if running from CLI (command line)
    if (php_sapi_name() === 'cli') {
        return 'http://192.168.1.42/v2/';
    }
    
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $path = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? ''), '/\\');
    
    // Remove script filename if present and ensure we get the v2 directory
    $pathParts = explode('/', $path);
    $basePath = '/v2';
    
    // If we're in a subdirectory of v2, go back to v2
    if (in_array('v2', $pathParts)) {
        $v2Index = array_search('v2', $pathParts);
        $basePath = '/' . implode('/', array_slice($pathParts, 0, $v2Index + 1));
    }
    
    return $protocol . $host . $basePath . '/';
}

// Get API base URL
function get_api_url() {
    return get_base_url() . 'api/';
}

// Get assets base URL
function get_assets_url() {
    return get_base_url() . 'assets/';
}

// Get photos base URL
function get_photos_url() {
    return get_base_url() . 'photos/';
}

// Define constants for easy access
define('BASE_URL', get_base_url());
define('API_URL', get_api_url());
define('ASSETS_URL', get_assets_url());
define('PHOTOS_URL', get_photos_url());

// Application settings
define('APP_NAME', 'StyleScore');
define('APP_VERSION', '2.0');

// Debug mode (set to false in production)
define('DEBUG_MODE', true);

?>
