<?php
require_once 'includes/db.php';

echo "<h2>Event 3 Result Configurations</h2>";

$stmt = $pdo->prepare('SELECT * FROM result_configurations WHERE event_id = 3');
$stmt->execute();
$configs = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<pre>";
foreach ($configs as $config) {
    echo "Config ID: " . $config['id'] . "\n";
    echo "Name: " . $config['name'] . "\n";
    echo "View Type: " . $config['view_type'] . "\n";
    echo "Heat Number: " . ($config['heat_number'] ?? 'NULL') . "\n";
    echo "Status: " . $config['status'] . "\n";
    echo "\nConfiguration JSON:\n";
    print_r(json_decode($config['configuration'], true));
    echo "\n" . str_repeat("=", 80) . "\n\n";
}
echo "</pre>";

// Also check what figures exist in the scores
echo "<h2>Figures in Scores for Event 3</h2>";
$stmt = $pdo->prepare("
    SELECT s.id, s.figures_json, p.first_name, p.last_name
    FROM scores s
    JOIN runs r ON s.run_id = r.id
    JOIN event_participants ep ON r.event_participant_id = ep.id
    JOIN participants p ON ep.participant_id = p.id
    WHERE ep.event_id = 3 
    AND s.figures_json IS NOT NULL 
    AND s.figures_json != ''
    LIMIT 5
");
$stmt->execute();
$scores = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<pre>";
foreach ($scores as $score) {
    echo "Score ID: " . $score['id'] . " - " . $score['first_name'] . " " . $score['last_name'] . "\n";
    echo "Figures: " . $score['figures_json'] . "\n\n";
}
echo "</pre>";
