<?php
// Database structure check
$host = 'localhost';
$db = 'freestyle_db';
$user = 'root';
$pass = '';
$dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h3>Database Tables:</h3>";
    $stmt = $pdo->query("SHOW TABLES");
    while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
        echo "📋 " . $row[0] . "<br>";
    }
    
    echo "<h3>Events Table:</h3>";
    $stmt = $pdo->query("SELECT id, name, scoring_format FROM events LIMIT 5");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "Event {$row['id']}: {$row['name']} (format: {$row['scoring_format']})<br>";
    }
    
    echo "<h3>Event Participants for Event 3:</h3>";
    $stmt = $pdo->prepare("SELECT ep.id, ep.bib_number, p.first_name, p.last_name, ep.heat_number FROM event_participants ep JOIN participants p ON ep.participant_id = p.id WHERE ep.event_id = 3 LIMIT 10");
    $stmt->execute();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "BIB {$row['bib_number']}: {$row['first_name']} {$row['last_name']} (Heat {$row['heat_number']})<br>";
    }
    
    echo "<h3>Scoring Formats:</h3>";
    $stmt = $pdo->query("SELECT format_id, name, sport FROM scoring_formats LIMIT 5");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "Format {$row['format_id']}: {$row['name']} (sport: {$row['sport']})<br>";
    }
    
    echo "<h3>Figures Table Check:</h3>";
    try {
        $stmt = $pdo->query("SELECT sport, category, item FROM figures LIMIT 10");
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            echo "Sport: {$row['sport']}, Category: {$row['category']}, Item: {$row['item']}<br>";
        }
    } catch (Exception $e) {
        echo "Figures table error: " . $e->getMessage() . "<br>";
    }
    
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
?>
