<?php
include 'includes/db.php';

echo "Checking scoring formats and criteria...\n";

// Check if there are any formats
$formatCount = $pdo->query('SELECT COUNT(*) FROM scoring_formats')->fetchColumn();
echo "Total formats: $formatCount\n";

// Check if there are any criteria
$criteriaCount = $pdo->query('SELECT COUNT(*) FROM scoring_format_criteria')->fetchColumn();
echo "Total criteria: $criteriaCount\n";

// Show sample format-criteria relationships
$stmt = $pdo->query('SELECT sf.name as format_name, sf.format_id, COUNT(sfc.id) as criteria_count 
                     FROM scoring_formats sf 
                     LEFT JOIN scoring_format_criteria sfc ON sf.format_id = sfc.format_id 
                     GROUP BY sf.format_id 
                     ORDER BY criteria_count DESC 
                     LIMIT 5');
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "Sample format-criteria counts:\n";
print_r($results);

// Check some sample criteria
if ($criteriaCount > 0) {
    echo "\nSample criteria:\n";
    $sampleCriteria = $pdo->query('SELECT * FROM scoring_format_criteria LIMIT 3')->fetchAll(PDO::FETCH_ASSOC);
    print_r($sampleCriteria);
}
?>
