<?php
include 'includes/db.php';

echo "Checking event_heat_settings table structure...\n\n";

// Check table columns
$stmt = $pdo->query("SHOW COLUMNS FROM event_heat_settings");
$columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Columns in event_heat_settings:\n";
foreach ($columns as $col) {
    echo "- {$col['Field']} ({$col['Type']})\n";
}

// Check for bib_performing column specifically
$stmt = $pdo->query("SHOW COLUMNS FROM event_heat_settings LIKE 'bib_performing'");
if ($stmt->rowCount() > 0) {
    echo "\n✓ bib_performing column exists\n";
} else {
    echo "\n✗ bib_performing column does NOT exist\n";
    echo "Adding bib_performing column...\n";
    
    try {
        $pdo->exec("ALTER TABLE event_heat_settings ADD COLUMN bib_performing VARCHAR(10) NULL COMMENT 'BIB number of currently performing participant'");
        echo "✓ bib_performing column added successfully\n";
    } catch (Exception $e) {
        echo "✗ Error adding bib_performing column: " . $e->getMessage() . "\n";
    }
}

// Check sample data
echo "\nSample data from event_heat_settings:\n";
$stmt = $pdo->query("SELECT id, event_id, heat_number, heat_name, bib_on_start, bib_latest_on_run, is_active FROM event_heat_settings LIMIT 5");
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($rows as $row) {
    echo "Heat {$row['heat_number']}: {$row['heat_name']} - Start: {$row['bib_on_start']}, Latest: {$row['bib_latest_on_run']}, Active: {$row['is_active']}\n";
}
?>
