<?php
include 'includes/db.php';

$format_id = 'freeski_slopestyle_sections_oi_copy_1762579299';

// Check if format exists
$stmt = $pdo->prepare('SELECT * FROM scoring_formats WHERE format_id = ?');
$stmt->execute([$format_id]);
$format = $stmt->fetch(PDO::FETCH_ASSOC);

echo "Looking for format_id: " . $format_id . "\n\n";

if ($format) {
    echo "✓ Format FOUND:\n";
    print_r($format);
} else {
    echo "✗ Format NOT FOUND\n\n";
    echo "Checking all formats with 'copy' in name:\n";
    $stmt = $pdo->prepare('SELECT format_id, name FROM scoring_formats WHERE format_id LIKE ?');
    $stmt->execute(['%copy%']);
    $copies = $stmt->fetchAll(PDO::FETCH_ASSOC);
    print_r($copies);
}
