<?php
// Simple API test
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "API Test Starting...\n";

// Test auth
try {
    include 'includes/auth_simple.php';
    echo "✅ Auth included successfully\n";
} catch (Exception $e) {
    echo "❌ Auth error: " . $e->getMessage() . "\n";
}

// Test database
try {
    include 'includes/db.php';
    echo "✅ Database connected successfully\n";
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage() . "\n";
}

// Test simple query
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM users");
    $stmt->execute();
    $count = $stmt->fetchColumn();
    echo "✅ Database query successful: $count users found\n";
} catch (Exception $e) {
    echo "❌ Query error: " . $e->getMessage() . "\n";
}

echo "API Test Complete\n";
?>
