<!DOCTYPE html>
<html>
<head>
    <title>Participant Edit Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Test Participant Edit with New Fields</h2>
    
    <?php
    // Test if participant_edit.php has the new fields support
    include '../includes/db.php';
    
    echo "<div class='alert alert-info'>";
    
    try {
        // Check if new columns exist in participants table
        $stmt = $pdo->query("DESCRIBE participants");
        $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        $has_photo = in_array('photo', $columns);
        $has_motion_video = in_array('motion_video', $columns);
        
        echo "<h5>Database Status:</h5>";
        echo "<ul>";
        echo "<li>photo column: " . ($has_photo ? "✓ EXISTS" : "✗ MISSING") . "</li>";
        echo "<li>motion_video column: " . ($has_motion_video ? "✓ EXISTS" : "✗ MISSING") . "</li>";
        echo "</ul>";
        
        // Check if participant_facts table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'participant_facts'");
        $has_facts_table = $stmt->rowCount() > 0;
        echo "<p>participant_facts table: " . ($has_facts_table ? "✓ EXISTS" : "✗ MISSING") . "</p>";
        
        // Get a sample participant to test edit functionality
        $stmt = $pdo->query("SELECT id, first_name, last_name, bib FROM participants LIMIT 1");
        $sample_participant = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($sample_participant) {
            echo "<h5>Sample Participant for Testing:</h5>";
            echo "<p>ID: {$sample_participant['id']} | ";
            echo "Name: {$sample_participant['first_name']} {$sample_participant['last_name']} | ";
            echo "BIB: {$sample_participant['bib']}</p>";
            
            $edit_url = "participant_edit.php?id=" . $sample_participant['id'];
            echo "<a href='$edit_url' class='btn btn-primary' target='_blank'>Test Edit This Participant</a>";
        } else {
            echo "<p class='text-warning'>No participants found to test with. Please add a participant first.</p>";
        }
        
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'>Database Error: " . $e->getMessage() . "</div>";
    }
    
    echo "</div>";
    ?>
    
    <div class="alert alert-success">
        <h5>Features Added to participant_edit.php:</h5>
        <ul>
            <li><strong>Photo Management:</strong> Upload new photos or remove existing ones</li>
            <li><strong>Motion Video Management:</strong> Upload new videos or remove existing ones</li>
            <li><strong>Facts Editor:</strong> Add, edit, or remove participant facts with dynamic repeater field</li>
            <li><strong>Media Preview:</strong> View current photos/videos before replacing</li>
            <li><strong>File Validation:</strong> Size and type validation for uploads</li>
        </ul>
    </div>
    
    <div class="alert alert-info">
        <h5>Testing Checklist:</h5>
        <ul>
            <li>✓ Upload a new photo (test file size validation)</li>
            <li>✓ Upload a new video (test file size validation)</li>
            <li>✓ Add multiple facts using "Add Another Fact" button</li>
            <li>✓ Remove facts using trash icon</li>
            <li>✓ Edit existing fact titles and descriptions</li>
            <li>✓ Remove existing media files</li>
            <li>✓ Save changes and verify they persist</li>
        </ul>
    </div>
    
    <div class="mt-4">
        <a href="participant_add.php" class="btn btn-secondary">Test Add Participant</a>
        <a href="participants.php" class="btn btn-info">View All Participants</a>
    </div>
</div>
</body>
</html>
