<?php
/**
 * Test script for heat_run_scores API endpoint
 */
include '../includes/auth_simple.php';
include '../includes/db.php';

// Set test parameters
$event_id = $_GET['event_id'] ?? 3;
$heat_number = $_GET['heat_number'] ?? 2;
$run_number = $_GET['run_number'] ?? 1;

echo "<h2>Testing Heat Run Scores API</h2>";
echo "<p><strong>Event ID:</strong> $event_id</p>";
echo "<p><strong>Heat Number:</strong> $heat_number</p>";
echo "<p><strong>Run Number:</strong> $run_number</p>";

// Test 1: Check if scoring_results table exists and has data
echo "<h3>1. Check scoring_results table</h3>";
try {
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM scoring_results");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>Total records in scoring_results: <strong>{$result['count']}</strong></p>";
    
    if ($result['count'] > 0) {
        // Show sample data
        $stmt = $pdo->query("SELECT * FROM scoring_results LIMIT 3");
        $samples = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "<pre>";
        print_r($samples);
        echo "</pre>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

// Test 2: Check for scores in specific heat/run
echo "<h3>2. Check scores for Heat $heat_number, Run $run_number</h3>";
try {
    $stmt = $pdo->prepare("
        SELECT 
            sr.*,
            ep.bib_number,
            ep.heat_number,
            p.first_name,
            p.last_name
        FROM scoring_results sr
        JOIN event_participants ep ON sr.participant_id = ep.id
        JOIN participants p ON ep.participant_id = p.id
        WHERE ep.event_id = ? 
            AND ep.heat_number = ?
            AND sr.run_number = ?
    ");
    $stmt->execute([$event_id, $heat_number, $run_number]);
    $scores = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<p>Found <strong>" . count($scores) . "</strong> scores</p>";
    
    if (count($scores) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>BIB</th><th>Name</th><th>Heat</th><th>Run</th><th>Judge ID</th><th>Score</th><th>Approved</th></tr>";
        foreach ($scores as $score) {
            echo "<tr>";
            echo "<td>{$score['bib_number']}</td>";
            echo "<td>{$score['first_name']} {$score['last_name']}</td>";
            echo "<td>{$score['heat_number']}</td>";
            echo "<td>{$score['run_number']}</td>";
            echo "<td>{$score['judge_id']}</td>";
            echo "<td>{$score['total_score']}</td>";
            echo "<td>" . ($score['approved'] ? 'Yes' : 'No') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: orange;'>No scores found for this heat/run combination</p>";
        
        // Check if there are scores for this event at all
        $stmt = $pdo->prepare("
            SELECT COUNT(*) as count, 
                   GROUP_CONCAT(DISTINCT ep.heat_number) as heats,
                   GROUP_CONCAT(DISTINCT sr.run_number) as runs
            FROM scoring_results sr
            JOIN event_participants ep ON sr.participant_id = ep.id
            WHERE ep.event_id = ?
        ");
        $stmt->execute([$event_id]);
        $eventScores = $stmt->fetch(PDO::FETCH_ASSOC);
        
        echo "<p>Event has <strong>{$eventScores['count']}</strong> total scores</p>";
        echo "<p>Available heats: {$eventScores['heats']}</p>";
        echo "<p>Available runs: {$eventScores['runs']}</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

// Test 3: Call the actual API
echo "<h3>3. Test API Endpoint</h3>";
$api_url = "heat_management_api.php?action=get_heat_run_scores&event_id=$event_id&heat_number=$heat_number&run_number=$run_number";
echo "<p>API URL: <code>$api_url</code></p>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://" . $_SERVER['HTTP_HOST'] . "/v2/admin/" . $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id());
$response = curl_exec($ch);
curl_close($ch);

echo "<h4>API Response:</h4>";
echo "<pre>";
echo htmlspecialchars($response);
echo "</pre>";

$data = json_decode($response, true);
if ($data) {
    echo "<h4>Parsed JSON:</h4>";
    echo "<pre>";
    print_r($data);
    echo "</pre>";
}
?>
