<?php
// Test full dashboard and API generation with report configurations
error_reporting(0); // Suppress warnings for cleaner output

// Set server variables for proper URL generation
$_SERVER['REQUEST_SCHEME'] = 'http';
$_SERVER['HTTP_HOST'] = 'localhost';
$_SERVER['REQUEST_URI'] = '/v2/admin/publish_servers.php';
$_SERVER['REQUEST_METHOD'] = 'POST';

require_once '../includes/db.php';
require_once 'publish_generators.php';

$event_id = 3;

echo "=== FULL DASHBOARD GENERATION TEST ===\n\n";

try {
    echo "1. Generating Static API Files...\n";
    $api_success = generateStaticAPIFiles($event_id, '../static_api/', $pdo);
    
    if ($api_success) {
        echo "✅ Static API files generated successfully\n";
        
        // Check if configurations.json was created
        $config_file = '../static_api/configurations.json';
        if (file_exists($config_file)) {
            echo "✅ configurations.json created\n";
            
            $config_data = json_decode(file_get_contents($config_file), true);
            if ($config_data) {
                echo "✅ configurations.json contains valid JSON\n";
                echo "   - Total configurations: " . count($config_data) . "\n";
                
                // Group by type
                $types = [];
                foreach ($config_data as $config) {
                    $types[$config['view_type']] = ($types[$config['view_type']] ?? 0) + 1;
                }
                
                foreach ($types as $type => $count) {
                    echo "   - $type: $count configurations\n";
                }
            } else {
                echo "❌ configurations.json contains invalid JSON\n";
            }
        } else {
            echo "❌ configurations.json not created\n";
        }
    } else {
        echo "❌ Static API generation failed\n";
    }
    
    echo "\n2. Generating Static HTML Dashboard...\n";
    $files = generateStaticHTMLDashboard($event_id, '../', $pdo);
    
    if (!empty($files)) {
        echo "✅ Static HTML dashboard generated\n";
        echo "   Generated files:\n";
        foreach ($files as $file) {
            echo "   - " . $file['remote'] . " (" . number_format(filesize($file['local'])) . " bytes)\n";
        }
        
        // Check if the dashboard HTML exists
        $html_file = '../public_event_dashboard_static.html';
        if (file_exists($html_file)) {
            echo "✅ Dashboard HTML created: " . basename($html_file) . "\n";
        }
        
        // Check dashboard.js for the eventId fix
        $js_file = '../dashboard.js';
        if (file_exists($js_file)) {
            echo "✅ Dashboard JS created\n";
            
            $js_content = file_get_contents($js_file);
            $fixed_count = substr_count($js_content, '${event.id}');
            $broken_count = substr_count($js_content, '${eventId}');
            
            echo "   Template literal analysis:\n";
            echo "   - Correct '\${event.id}': $fixed_count occurrences\n";
            echo "   - Incorrect '\${eventId}': $broken_count occurrences\n";
            
            if ($broken_count === 0) {
                echo "   ✅ All eventId references fixed\n";
            } else {
                echo "   ❌ Still has incorrect eventId references\n";
            }
        }
    } else {
        echo "❌ Static HTML dashboard generation failed\n";
    }
    
    echo "\n3. Testing Report Configuration Loading...\n";
    
    // Test the refreshGeneralReports function directly
    ob_start();
    $result = refreshGeneralReports($event_id, $pdo);
    $output = ob_get_clean();
    
    if ($result) {
        echo "✅ refreshGeneralReports function executed successfully\n";
        if (!empty($output)) {
            echo "   Function output:\n";
            echo "   " . str_replace("\n", "\n   ", trim($output)) . "\n";
        }
    } else {
        echo "❌ refreshGeneralReports function failed\n";
        if (!empty($output)) {
            echo "   Error output: $output\n";
        }
    }
    
    echo "\n=== TEST COMPLETE ===\n";
    echo "Access the static dashboard at: http://localhost/v2/public_event_dashboard_static.html\n";
    
} catch (Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
?>
