<?php
// Test actual AJAX publish request with proper server variables
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Simulate proper web environment to avoid warnings
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['REQUEST_SCHEME'] = 'http';
$_SERVER['HTTP_HOST'] = 'localhost';
$_SERVER['REQUEST_URI'] = '/v2/admin/publish_servers.php';
$_POST['action'] = 'publish_now';
$_POST['id'] = '2'; // Use the existing server ID from database

// Capture all output
ob_start();

// Include the actual publish_servers.php logic without HTML
try {
    // Include database connection
    require_once '../includes/db.php';
    require_once 'publish_generators.php';
    
    // Check for publish action specifically
    if ($_POST['action'] === 'publish_now' && isset($_POST['id'])) {
        $server_id = intval($_POST['id']);
        
        // Get server configuration
        $stmt = $pdo->prepare("SELECT * FROM publish_servers WHERE id = ?");
        $stmt->execute([$server_id]);
        $server = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$server) {
            echo json_encode(['success' => false, 'message' => 'Server not found']);
            exit;
        }
        
        // Test generating files without FTP
        $temp_dir = sys_get_temp_dir() . '/publish_test_' . time();
        mkdir($temp_dir, 0755, true);
        
        $all_files = [];
        $data_types = json_decode($server['data_types'], true);
        
        foreach ($data_types as $data_type) {
            switch ($data_type) {
                case 'html_dashboard':
                    $files = generateStaticHTMLDashboard($server['event_id'], $temp_dir, $pdo);
                    $all_files = array_merge($all_files, $files);
                    break;
                case 'json_data':
                    $files = generateJSONData($server['event_id'], $temp_dir, $pdo);
                    $all_files = array_merge($all_files, $files);
                    break;
                case 'csv_data':
                    $files = generateCSVData($server['event_id'], $temp_dir, $pdo);
                    $all_files = array_merge($all_files, $files);
                    break;
            }
        }
        
        echo json_encode([
            'success' => true, 
            'message' => 'Test publish completed successfully',
            'file_count' => count($all_files),
            'server_name' => $server['name'],
            'generated_files' => array_slice($all_files, 0, 5) // Show first 5 files
        ]);
        
        // Cleanup
        foreach ($all_files as $file) {
            if (file_exists($file['local'])) {
                unlink($file['local']);
            }
        }
        rmdir($temp_dir);
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$output = ob_get_clean();

// Always show what happened
echo "Output length: " . strlen($output) . "\n";
echo "Output content: " . $output . "\n";
?>
