-- Add colors column to event_categories table
-- Run this SQL to add color support to existing event_categories table

ALTER TABLE `event_categories` 
ADD COLUMN `colors` JSON NULL COMMENT 'Generated colors for the category (background-color, color, border-color)' 
AFTER `country_codes`;

-- Update the comment for the table
ALTER TABLE `event_categories` 
COMMENT = 'Event categories with dynamic color generation based on category names';

-- Example of how colors are stored:
-- {
--   "background-color": "#3a7bd5",
--   "color": "#ffffff", 
--   "border-color": "#2e5fa8",
--   "background-light": "#e8f2ff",
--   "css_class": "category-mens-pro"
-- }
