<?php
session_start();
$_SESSION['user_logged_in'] = true;
$_SESSION['user_type'] = 'admin';

include '../includes/db.php';

$selected_event = $_GET['event_id'] ?? null;
$events = $pdo->query("SELECT id, name, date FROM events ORDER BY date DESC")->fetchAll(PDO::FETCH_ASSOC);

// Simple query without complex joins
$scores = [];
if ($selected_event) {
    $scores_stmt = $pdo->prepare("
        SELECT s.id AS score_id, e.name AS event_name,
               p.first_name, p.last_name, ep.bib_number as bib,
               r.run_number, s.score_value, s.status, u.username AS judge_name,
               ep.heat_number
        FROM scores s
        JOIN runs r ON s.run_id = r.id
        JOIN event_participants ep ON r.event_participant_id = ep.id
        JOIN participants p ON ep.participant_id = p.id
        JOIN events e ON ep.event_id = e.id
        JOIN users u ON s.judge_id = u.id
        WHERE ep.event_id = ?
        ORDER BY s.created_at DESC
        LIMIT 50
    ");
    $scores_stmt->execute([$selected_event]);
    $scores = $scores_stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Head Judge Override - Simple Version</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container-fluid container-StyleScore p-4">
    <h2>Head Judge Override Panel - Simple Test</h2>
    
    <!-- Event Selection -->
    <form method="get" class="mb-4">
        <div class="row">
            <div class="col-md-4">
                <select name="event_id" class="form-select" onchange="this.form.submit()">
                    <option value="">-- Select Event --</option>
                    <?php foreach ($events as $event): ?>
                        <option value="<?= $event['id'] ?>" <?= $selected_event == $event['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($event['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
    </form>
    
    <!-- Results -->
    <div class="alert alert-info">
        Found <?= count($scores) ?> scores
        <?php if ($selected_event): ?>
            for event ID <?= $selected_event ?>
        <?php endif; ?>
    </div>
    
    <!-- Simple Table -->
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Event</th>
                <th>Participant</th>
                <th>Heat</th>
                <th>Run</th>
                <th>Judge</th>
                <th>Score</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($scores)): ?>
                <tr>
                    <td colspan="8" class="text-center">
                        <?= $selected_event ? 'No scores found' : 'Please select an event' ?>
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($scores as $score): ?>
                <tr>
                    <td><?= htmlspecialchars($score['event_name']) ?></td>
                    <td>
                        <span class="badge bg-primary"><?= $score['bib'] ?></span>
                        <?= htmlspecialchars($score['first_name']) ?> <?= htmlspecialchars($score['last_name']) ?>
                    </td>
                    <td>Heat <?= $score['heat_number'] ?></td>
                    <td>Run <?= $score['run_number'] ?></td>
                    <td><?= htmlspecialchars($score['judge_name']) ?></td>
                    <td><strong><?= $score['score_value'] ?></strong></td>
                    <td>
                        <span class="badge bg-<?= $score['status'] == 'OK' ? 'success' : 'warning' ?>">
                            <?= $score['status'] ?>
                        </span>
                    </td>
                    <td>
                        <button class="btn btn-sm btn-primary" onclick="alert('Edit score ID: <?= $score['score_id'] ?>')">
                            Edit
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="mt-4">
        <a href="head_judge_override.php" class="btn btn-secondary">Back to Full Version</a>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
