<?php
require_once '../includes/db.php';

echo "=== PUBLISH SERVERS DEBUG ===\n\n";

// Check all servers and their data types
$stmt = $pdo->query("SELECT id, name, event_id, data_types, is_active FROM publish_servers");
$servers = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Found " . count($servers) . " servers:\n\n";

foreach ($servers as $server) {
    echo "Server ID: {$server['id']}\n";
    echo "Name: {$server['name']}\n";
    echo "Event ID: {$server['event_id']}\n";
    echo "Active: " . ($server['is_active'] ? 'Yes' : 'No') . "\n";
    echo "Data Types (raw): {$server['data_types']}\n";
    
    $data_types = json_decode($server['data_types'], true);
    echo "Data Types (decoded): " . print_r($data_types, true) . "\n";
    echo "Data Types Count: " . (is_array($data_types) ? count($data_types) : 0) . "\n";
    echo "---\n\n";
}

// Check if generateCSVData is being called vs others
echo "=== FUNCTION TEST ===\n";

try {
    $event_id = 1; // Test with event 1
    $temp_dir = sys_get_temp_dir() . '/debug_test_' . time();
    mkdir($temp_dir, 0755, true);
    
    echo "Testing CSV generation...\n";
    $csv_files = generateCSVData($event_id, $temp_dir, $pdo);
    echo "CSV files generated: " . count($csv_files) . "\n";
    foreach ($csv_files as $file) {
        echo "  - {$file['remote']}: " . (file_exists($file['local']) ? filesize($file['local']) . " bytes" : "FILE NOT FOUND") . "\n";
    }
    
    echo "\nTesting JSON generation...\n";
    $json_files = generateJSONData($event_id, $temp_dir, $pdo);
    echo "JSON files generated: " . count($json_files) . "\n";
    foreach ($json_files as $file) {
        echo "  - {$file['remote']}: " . (file_exists($file['local']) ? filesize($file['local']) . " bytes" : "FILE NOT FOUND") . "\n";
    }
    
    echo "\nTesting HTML generation...\n";
    $html_files = generateHTMLDashboard($event_id, $temp_dir, $pdo);
    echo "HTML files generated: " . count($html_files) . "\n";
    foreach ($html_files as $file) {
        echo "  - {$file['remote']}: " . (file_exists($file['local']) ? filesize($file['local']) . " bytes" : "FILE NOT FOUND") . "\n";
    }
    
    // Clean up
    $files = glob($temp_dir . '/*');
    foreach ($files as $file) {
        if (is_file($file)) unlink($file);
    }
    rmdir($temp_dir);
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
?>
