<?php
require_once '../includes/db.php';
require_once 'publish_generators.php';

echo "<h2>Photo Upload Debug Test</h2>";

$event_id = 3;
$temp_dir = sys_get_temp_dir() . '/stylescore_photo_test_' . time();

if (!is_dir($temp_dir)) {
    mkdir($temp_dir, 0777, true);
}

echo "<p>Testing photo copying for event $event_id</p>";
echo "<p>Temp directory: $temp_dir</p>";

// Test photo copying function directly
try {
    $photo_files = copyParticipantPhotos($event_id, $temp_dir, $pdo);
    
    echo "<h3>Photo Copy Results</h3>";
    echo "<p>Photos found and copied: " . count($photo_files) . "</p>";
    
    if (!empty($photo_files)) {
        echo "<table border='1'>";
        echo "<tr><th>Remote Path</th><th>Local Path</th><th>Exists</th><th>Size</th></tr>";
        
        foreach ($photo_files as $file) {
            $exists = file_exists($file['local']);
            $size = $exists ? filesize($file['local']) : 0;
            
            echo "<tr>";
            echo "<td>" . htmlspecialchars($file['remote']) . "</td>";
            echo "<td>" . htmlspecialchars($file['local']) . "</td>";
            echo "<td>" . ($exists ? "✓" : "✗") . "</td>";
            echo "<td>$size bytes</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Check if photos directory was created
    $photos_dir = $temp_dir . '/photos';
    if (is_dir($photos_dir)) {
        echo "<h3>Photos Directory Contents</h3>";
        $files = scandir($photos_dir);
        foreach ($files as $file) {
            if ($file != '.' && $file != '..') {
                $size = filesize($photos_dir . '/' . $file);
                echo "<p>$file - $size bytes</p>";
            }
        }
    } else {
        echo "<p style='color: red;'>Photos directory was not created</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error testing photo copy: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h3>Manual Photo Search</h3>";

// Manually check for photos
$stmt = $pdo->prepare("
    SELECT p.id, p.photo, p.name, ep.bib_number
    FROM participants p
    INNER JOIN event_participants ep ON p.id = ep.participant_id
    WHERE ep.event_id = ?
    ORDER BY ep.bib_number
");
$stmt->execute([$event_id]);
$participants = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<p>Checking " . count($participants) . " participants for photos...</p>";

foreach ($participants as $participant) {
    if ($participant['photo']) {
        echo "<h4>Participant: " . htmlspecialchars($participant['name']) . " (Bib: " . $participant['bib_number'] . ")</h4>";
        echo "<p>Photo field: " . htmlspecialchars($participant['photo']) . "</p>";
        
        // Check all possible photo locations
        $base_paths = [
            __DIR__ . '/../uploads/',
            __DIR__ . '/../uploads/participants/',
            __DIR__ . '/../uploads/profile_stills/',
            __DIR__ . '/../profile_stills/',
            __DIR__ . '/../../uploads/',
            __DIR__ . '/../../uploads/participants/',
            __DIR__ . '/../../uploads/profile_stills/'
        ];
        
        $found = false;
        foreach ($base_paths as $base_path) {
            $full_path = $base_path . $participant['photo'];
            if (file_exists($full_path)) {
                $size = filesize($full_path);
                echo "<p style='color: green;'>✓ Found at: $full_path ($size bytes)</p>";
                $found = true;
                
                // Try to copy it to our test directory
                $test_copy_path = $temp_dir . '/test_' . $participant['id'] . '_' . basename($participant['photo']);
                if (copy($full_path, $test_copy_path)) {
                    echo "<p style='color: green;'>✓ Successfully copied to test directory</p>";
                } else {
                    echo "<p style='color: red;'>✗ Failed to copy to test directory</p>";
                }
                break;
            }
        }
        
        if (!$found) {
            echo "<p style='color: red;'>✗ Photo not found in any location</p>";
        }
    }
}

// Cleanup
if (is_dir($temp_dir)) {
    $files = glob($temp_dir . '/*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
    
    $photos_dir = $temp_dir . '/photos';
    if (is_dir($photos_dir)) {
        $photo_files = glob($photos_dir . '/*');
        foreach ($photo_files as $file) {
            if (is_file($file)) {
                unlink($file);
            }
        }
        rmdir($photos_dir);
    }
    
    rmdir($temp_dir);
    echo "<p>Cleaned up temp directory</p>";
}
?>
