<?php
include '../includes/auth.php';
include '../includes/db.php';

$event_id = $_GET['id'] ?? 3;

echo "<h1>Debug Event Values for ID: $event_id</h1>";

// Fetch existing event data with correct column names matching database structure
$stmt = $pdo->prepare("SELECT id, name, date, location, scoring_mode, scoring_format, runs_per_heat, heats_total, sport_discipline, description, max_participants, age_limit, entry_fee, contact_email, contact_phone, registration_deadline, status, owner_group_id FROM events WHERE id = ?");
$stmt->execute([$event_id]);
$event = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<h2>Raw Database Results:</h2>";
echo "<pre>";
print_r($event);
echo "</pre>";

echo "<h2>Individual Values:</h2>";
echo "<ul>";
echo "<li><strong>ID:</strong> " . ($event['id'] ?? 'NULL') . "</li>";
echo "<li><strong>Name:</strong> " . ($event['name'] ?? 'NULL') . "</li>";
echo "<li><strong>Location:</strong> " . ($event['location'] ?? 'NULL') . "</li>";
echo "<li><strong>Sport Discipline:</strong> " . ($event['sport_discipline'] ?? 'NULL') . "</li>";
echo "<li><strong>Scoring Format:</strong> " . ($event['scoring_format'] ?? 'NULL') . "</li>";
echo "<li><strong>Scoring Mode:</strong> " . ($event['scoring_mode'] ?? 'NULL') . "</li>";
echo "<li><strong>Date:</strong> " . ($event['date'] ?? 'NULL') . "</li>";
echo "</ul>";

echo "<h2>JSON Encode Test:</h2>";
echo "<pre>";
echo "sport_discipline: " . json_encode($event['sport_discipline'] ?? '') . "\n";
echo "scoring_format: " . json_encode($event['scoring_format'] ?? '') . "\n";
echo "scoring_mode: " . json_encode($event['scoring_mode'] ?? '') . "\n";
echo "location: " . json_encode($event['location'] ?? '') . "\n";
echo "</pre>";

echo "<h2>Direct Database Query Test:</h2>";
$direct_stmt = $pdo->prepare("SELECT * FROM events WHERE id = ?");
$direct_stmt->execute([$event_id]);
$direct_event = $direct_stmt->fetch(PDO::FETCH_ASSOC);

echo "<pre>";
print_r($direct_event);
echo "</pre>";
?>