# Participant Status System Migration

## Overview
Migrating from BIB-based tracking system to status-based participant workflow.

## Database Changes

### New Columns in `event_participants`
- `participant_status` VARCHAR(20) DEFAULT 'initial'
- `run_number` INT DEFAULT 1

### Valid Status Values
1. **initial** - Default state, hasn't started
2. **next_up** - Next in line to perform
3. **start_gate** - At start gate, ready to begin
4. **performing** - Currently performing
5. **completed** - Finished performance
6. **dns** - Did Not Start (no-show)
7. **dnf** - Did Not Finish

## Migration Steps

### 1. Run Database Migration
```
http://localhost/v2/admin/add_participant_status_column.php
```

### 2. API Endpoints (participant_status_api.php)

#### GET /get_status
Returns all participants with their statuses for a heat/run

#### POST /update_status
Update individual participant status

#### POST /advance_next
Auto-advance workflow:
- Current performing → completed
- Start gate → performing  
- Next initial → start gate
- Next+1 initial → next_up

#### POST /mark_performing
Manually set specific participant as performing

#### POST /mark_completed
Mark current performing as completed

#### POST /reset_heat
Reset all participants to initial

#### GET /get_current
Get current performing, start_gate, next_up participants

## UI Changes in heat_management_modal.php

###  REMOVE (Old System)
- `bib_performing` field and logic
- `bib_on_start` field and logic
- `bib_latest_on_run` field and logic
- `onBibPerformingChange()` function
- `onBibOnStartChange()` function
- Manual BIB input fields

### ADD (New System)
- Status-based participant display
- Auto-advance button
- Status indicators (color-coded badges)
- Participant playlist view with drag-drop reordering
- Quick status change buttons per participant

## Benefits

1. **Better Workflow** - Clear status progression
2. **No Manual BIB Entry** - Click-based interface
3. **Visual Status** - Color-coded participant states
4. **Playlist View** - See upcoming participants
5. **Flexible** - Can mark DNS/DNF
6. **Trackable** - Full status history possible

## Implementation Plan

1. ✅ Create database migration script
2. ✅ Create participant_status_api.php
3. ⏳ Update heat_management_modal.php UI
4. ⏳ Replace old functions with new API calls
5. ⏳ Add status visualization
6. ⏳ Test workflow
