# Participant Edit Enhancement - Media Fields Update

## Overview
Updated `participant_edit.php` to include the new media and facts fields:
- **Photo Upload/Management**: Upload, view, and remove participant photos
- **Motion Video Upload/Management**: Upload, view, and remove motion videos  
- **Facts Management**: Dynamic editing of participant facts with add/remove functionality

## Changes Made to participant_edit.php

### 1. Database Integration
- Added loading of existing participant facts from `participant_facts` table
- Updated to load photo and motion_video fields from participants table
- Added proper file upload handling and validation

### 2. Form Enhancements

#### New Fields Added:
- **Photo Upload Section**:
  - File input for new photo uploads
  - Display of current photo (if exists)
  - Preview functionality for current photos
  - Remove button for existing photos
  
- **Motion Video Upload Section**:
  - File input for new video uploads
  - Display of current video info (if exists)
  - File size information display
  - Remove button for existing videos

- **Facts Management Section**:
  - Dynamic repeater field for facts
  - Pre-populated with existing facts
  - Add/remove buttons for facts management
  - Title and description fields for each fact

### 3. File Upload Features

#### Photo Management:
- **Supported formats**: JPG, JPEG, PNG, GIF, WEBP
- **Max file size**: 5MB
- **Features**:
  - Replace existing photos
  - Remove existing photos
  - Image preview
  - File validation

#### Video Management:
- **Supported formats**: MP4, AVI, MOV, WMV, WEBM, MKV
- **Max file size**: 50MB
- **Features**:
  - Replace existing videos
  - Remove existing videos
  - File information display
  - File validation

### 4. JavaScript Enhancements

#### Dynamic Facts Management:
```javascript
// Add new fact entry
function addFact()

// Remove fact entry
function removeFact(button)

// Update delete button visibility
function updateFactDeleteButtons()
```

#### File Upload Validation:
- Client-side file size validation
- File type validation
- Image preview for photos
- Video information display

#### Media Removal:
```javascript
// Mark media for removal
function removeMedia(type)
```

### 5. Backend Processing

#### File Upload Handling:
- Secure file upload with validation
- Automatic file naming with timestamps
- Old file cleanup when replacing
- Storage in `uploads/participants/` directory

#### Facts Processing:
- Delete existing facts before inserting new ones
- Maintain sort order for facts
- Handle empty/invalid fact entries

#### Media Removal:
- Handle removal flags from form
- Delete files from filesystem
- Update database records

## Form Structure

### Media Files Section:
```html
<!-- Photo Upload -->
<div class="col-md-6">
    <label for="photo">Participant Photo</label>
    <!-- Current photo display -->
    <!-- New photo upload -->
    <!-- Remove functionality -->
</div>

<!-- Video Upload -->
<div class="col-md-6">
    <label for="motion_video">Motion Video</label>
    <!-- Current video info -->
    <!-- New video upload -->
    <!-- Remove functionality -->
</div>
```

### Facts Management Section:
```html
<!-- Facts Container -->
<div id="factsContainer">
    <!-- Dynamic fact items -->
    <div class="fact-item">
        <!-- Title input -->
        <!-- Description textarea -->
        <!-- Remove button -->
    </div>
</div>
<!-- Add fact button -->
```

## CSS Styling

### Added Styles:
- `.fact-item`: Styled fact entry containers
- `.existing-media`: Highlighted existing media display
- `.media-preview`: Image preview styling
- `.media-info`: Video information display

## Security Features

### File Upload Security:
- Whitelist-based file type validation
- File size limits enforced
- Unique file naming to prevent conflicts
- Proper file path handling

### Data Validation:
- Server-side validation for all inputs
- Prepared statements for database queries
- HTML escaping for output

## Usage Instructions

### Editing Media:
1. **To replace photo**: Upload new file in photo section
2. **To remove photo**: Click "Remove" button next to current photo
3. **To replace video**: Upload new file in video section  
4. **To remove video**: Click "Remove" button next to current video

### Managing Facts:
1. **Edit existing facts**: Modify title/description in existing entries
2. **Add new fact**: Click "Add Another Fact" button
3. **Remove fact**: Click trash icon on unwanted facts
4. **Reorder facts**: Facts maintain the order they appear in the form

### Form Submission:
- All changes (media and facts) are saved together
- Old media files are automatically cleaned up
- Facts are completely refreshed (old deleted, new inserted)

## File Organization

### Modified Files:
- `admin/participant_edit.php` - Main edit form with new fields
- `admin/test_participant_edit.php` - Test file for validation

### Dependencies:
- `includes/country_codes.php` - Country selection functionality
- `uploads/participants/` - Media file storage directory
- Bootstrap 5 - UI framework
- Font Awesome - Icons

## Error Handling

### Upload Errors:
- File size validation with user-friendly messages
- File type validation with clear error messages
- File system error handling

### Database Errors:
- Transaction-like handling for facts (delete then insert)
- Proper error messages for constraint violations
- Graceful fallback for missing data

## Testing

Use `test_participant_edit.php` to verify:
- Database schema compatibility
- Form functionality
- File upload capabilities
- Sample participant for testing

## Compatibility

### Requirements:
- PHP 7.4+ (for null coalescing operator)
- MySQL/MariaDB with participant_facts table
- File upload permissions for uploads directory
- Bootstrap 5 and Font Awesome for UI

### Browser Support:
- Modern browsers with JavaScript enabled
- File API support for upload previews
- FormData API for AJAX submissions
