
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard - Freestyle Scoring App</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; padding: 20px; }
        .tool-card { margin-bottom: 20px; }
        header { margin-bottom: 30px; }
    </style>
</head>
<body>
<header>
    <h1>🎿 Freestyle Scoring Dashboard</h1>
    <p class="text-muted">Welcome to the scoring administration panel. Use the tools below to manage events, scores, participants, and live scoreboards.</p>
</header>
<div class="container">
    <div class="row">
        <div class="col-md-6 tool-card">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Live Scoreboard - Tabs View</h5>
                    <p class="card-text">Tabbed interface for Category View, Heat & Run View, and Summary View.</p>
                    <a href="live_scoreboard_tabs.php" class="btn btn-primary">Open View</a>
                </div>
            </div>
        </div>
        <div class="col-md-6 tool-card">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">View 1 - By Category</h5>
                    <p class="card-text">Separate scoreboard per category with average scores, participant info, filters.</p>
                    <a href="live_scoreboard_1.php" class="btn btn-secondary">Open View</a>
                </div>
            </div>
        </div>
        <div class="col-md-6 tool-card">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">View 2 - By Heat & Run</h5>
                    <p class="card-text">Breakdown of each heat and run per participant with scores.</p>
                    <a href="live_scoreboard_2.php" class="btn btn-secondary">Open View</a>
                </div>
            </div>
        </div>
        <div class="col-md-6 tool-card">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">View 3 - Summary Table</h5>
                    <p class="card-text">Matrix view with participants' average scores across all heats and runs.</p>
                    <a href="live_scoreboard_3.php" class="btn btn-secondary">Open View</a>
                </div>
            </div>
        </div>
        <div class="col-md-6 tool-card">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Admin Panel</h5>
                    <p class="card-text">Manage participants, events, judges, and assignments.</p>
                    <a href="admin/" class="btn btn-warning">Go to Admin Panel</a>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
