
<?php
include 'includes/db.php';

$selected_event = $_GET['event_id'] ?? null;

// Fetch events for dropdown
$events = $pdo->query("SELECT id, name FROM events ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

// Fetch live scores
$scores = [];
if ($selected_event) {
    $stmt = $pdo->prepare("
        SELECT r.run_id, p.bip, p.first_name, p.last_name, p.club, p.country, AVG(s.score_value) as average_score, GROUP_CONCAT(s.score_value ORDER BY s.judge_id) as all_scores
        FROM runs r
        JOIN event_participants ep ON r.event_participant_id = ep.id
        JOIN participants p ON ep.participant_id = p.id
        LEFT JOIN scores s ON s.run_id = r.id
        WHERE ep.event_id = ?
        GROUP BY r.id
        ORDER BY average_score DESC
    ");
    $stmt->execute([$selected_event]);
    $scores = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Live Scoreboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <meta http-equiv="refresh" content="10">
    <style>
        body { background: #f8f9fa; padding: 20px; }
        .scoreboard-table { background: white; border-radius: 10px; overflow: hidden; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        th, td { text-align: center; vertical-align: middle; }
        th { background: #343a40; color: white; }
        .highlight { font-weight: bold; color: #198754; }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="mb-4">Live Scoreboard</h1>
        <form method="get" class="mb-4">
            <label for="event_id" class="form-label">Select Event:</label>
            <select name="event_id" id="event_id" class="form-select" onchange="this.form.submit()" required>
                <option value="">-- Choose Event --</option>
                <?php foreach ($events as $event): ?>
                    <option value="<?= $event['id'] ?>" <?= $event['id'] == $selected_event ? 'selected' : '' ?>>
                        <?= htmlspecialchars($event['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </form>

        <?php if ($selected_event): ?>
        <div class="scoreboard-table table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>BIB</th>
                        <th>Name</th>
                        <th>Club</th>
                        <th>Country</th>
                        <th>Judge Scores</th>
                        <th>Average</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($scores as $score): ?>
                        <tr>
                            <td><?= htmlspecialchars($score['bip']) ?></td>
                            <td><?= htmlspecialchars($score['first_name'] . ' ' . $score['last_name']) ?></td>
                            <td><?= htmlspecialchars($score['club']) ?></td>
                            <td><?= htmlspecialchars($score['country']) ?></td>
                            <td><?= htmlspecialchars($score['all_scores']) ?></td>
                            <td class="highlight"><?= number_format($score['average_score'], 2) ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($scores)): ?>
                        <tr><td colspan="6">No scores available for this event.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
