<?php
include '../includes/auth_judge.php';
include '../includes/db.php';


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reset_score'])) {
    $stmt = $pdo->prepare("
        DELETE s FROM scores s
        JOIN runs r ON s.run_id = r.id
        JOIN event_participants ep ON r.event_participant_id = ep.id
        WHERE s.judge_id = ? AND ep.event_id = ?
    ");
    $stmt->execute([$_POST['judge_id'], $_POST['event_id']]);
    header("Location: score.php?event_id=" . intval($_POST['event_id']) . "&reset=1");
    exit;
}


$judge_id = $_SESSION['judge_id'];
$message = '';
$manual_mode = isset($_GET['manual']) && $_GET['manual'] == 1;

// Get assigned events
$assigned_event_stmt = $pdo->prepare("SELECT e.id, e.name FROM events e
    JOIN judge_assignments ja ON e.id = ja.event_id
    WHERE ja.judge_id = ?");
$assigned_event_stmt->execute([$judge_id]);
$assigned_events = $assigned_event_stmt->fetchAll(PDO::FETCH_ASSOC);

// Get selected event
$event_id = $manual_mode ? ($_POST['event_id'] ?? '') : ($assigned_events[0]['id'] ?? null);

// Fetch participants and runs
$participants = [];
if ($event_id) {
    $stmt = $pdo->prepare("SELECT ep.id as ep_id, p.name, ep.heat_number
                           FROM event_participants ep
                           JOIN participants p ON ep.participant_id = p.id
                           WHERE ep.event_id = ?");
    $stmt->execute([$event_id]);
    $participants = $stmt->fetchAll(PDO::FETCH_ASSOC);


$scored_runs = $pdo->prepare("
    SELECT DISTINCT r.event_participant_id, r.run_number
    FROM scores s
    JOIN runs r ON s.run_id = r.id
    WHERE s.judge_id = ?
");
$scored_runs->execute([$judge_id]);
$locked_scores = [];
foreach ($scored_runs as $row) {
    $locked_scores[$row['event_participant_id']][$row['run_number']] = true;
}

}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ep_id'])) {
    $run_number = $_POST['run_number'];
    $ep_id = $_POST['ep_id'];
    $score_value = $_POST['score_value'] !== '' ? floatval($_POST['score_value']) : null;
    $status = $_POST['status'];

    // Create or get run
    
    // Validate participant assignment
    $validate_stmt = $pdo->prepare("SELECT 1 FROM event_participants WHERE id = ?");
    $validate_stmt->execute([$ep_id]);
    if (!$validate_stmt->fetch()) {
        die('<div class="alert alert-danger">Participant not assigned to event/heat. Please check your selection.</div>');
    }

    $run_stmt = $pdo->prepare("SELECT id FROM runs WHERE event_participant_id = ? AND run_number = ?");
    $run_stmt->execute([$ep_id, $run_number]);
    $run = $run_stmt->fetch(PDO::FETCH_ASSOC);

    if (!$run) {
        $insert_run = $pdo->prepare("INSERT INTO runs (event_participant_id, run_number) VALUES (?, ?)");
        $insert_run->execute([$ep_id, $run_number]);
        $run_id = $pdo->lastInsertId();
    } else {
        $run_id = $run['id'];
    }

    // Insert score
    $insert_score = $pdo->prepare("REPLACE INTO scores (run_id, judge_id, score_value, status)
                                   VALUES (?, ?, ?, ?)");
    $insert_score->execute([$run_id, $judge_id, $score_value, $status]);

    $message = '<div class="alert alert-success">Score submitted!</div>';
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Judge Scoring</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">




<script>
function loadParticipants() {
    const heat = document.querySelector('[name=heat_number]').value;
    const run = document.querySelector('[name=run_number]').value;
    const target = document.querySelector('[name=ep_id]');
    const eventId = <?= $event_id ?>;

    if (!heat || !eventId || !run) return;

    fetch('get_participants.php?event_id=' + eventId + '&heat_number=' + heat + '&run_number=' + run)
        .then(res => res.json())
        .then(data => {
            target.innerHTML = '<option value="">-- Select Participant --</option>';
            data.forEach(p => {
                const lock = p.locked ? '🔒' : '✅';
                const option = document.createElement('option');
                option.value = p.ep_id;
                option.textContent = p.first_name + ' ' + p.last_name + ' (Heat ' + p.heat_number + ') ' + lock;
                if (p.locked) option.disabled = true;
                target.appendChild(option);
            });
        });
}
</script>




</head>
<body>
<div class="container mt-5">
    <h2>Judge Score Entry</h2>
    <?php echo $message; ?>

    <div class="mb-3">
        <a href="?manual=1" class="btn btn-outline-secondary btn-sm">Switch to Manual Mode</a>
        <a href="score.php" class="btn btn-outline-secondary btn-sm">Auto Mode</a>
    </div>

    <form method="post">
        <?php if ($manual_mode): ?>
        <div class="mb-3">
            <label class="form-label">Select Event</label>
            <select class="form-select" name="event_id" onchange="this.form.submit()">
                <option value="">-- Select Event --</option>
                <?php foreach ($assigned_events as $ev): ?>
                    <option value="<?= $ev['id'] ?>" <?= $event_id == $ev['id'] ? 'selected' : '' ?>><?= $ev['name'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <?php endif; ?>

        <div class="mb-3">
            <label class="form-label">Participant</label>
            


<div class="mb-3">
  <label class="form-label">Run Number</label>
  <input type="number" name="run_number" class="form-control" min="1" max="3" onchange="loadParticipants()" required>
</div>
<select class="form-select" name="ep_id" required>
        <option value="">-- Select Participant --</option>
    </select>


        </div>

        <div class="mb-3">
            <label class="form-label">Heat Number</label>
    <input type="number" class="form-control" name="heat_number" min="1" max="10" onchange="loadParticipants()" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Score (0-99)</label>
            <input type="number" class="form-control" name="score_value" min="0" max="99" step="0.1">
        </div>

        <div class="mb-3">
            <label class="form-label">Status</label>
            <select class="form-select" name="status" required>
                <option value="OK" selected>OK</option>
                <option value="DNS">DNS</option>
                <option value="DNF">DNF</option>
                <option value="DSQ">DSQ</option>
            </select>
        </div>

        <button type="submit" class="btn btn-primary">Submit Score</button>
    

</form>
</div>

<!-- Separate form for resetting scores -->
<form method="post" class="mt-4" onsubmit="return confirm('Are you sure you want to reset all your scores for this event?');">
  <input type="hidden" name="reset_score" value="1">
  <input type="hidden" name="judge_id" value="<?= $judge_id ?>">
  <input type="hidden" name="event_id" value="<?= $event_id ?>">
  <button type="submit" class="btn btn-outline-danger btn-sm">Reset My Scores for This Event</button>
</form>

</body>
</html>
