<?php
session_start();
include '../includes/auth_admin.php';
include '../includes/db.php';

if (!isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'head_judge') {
    //die("Access denied: Not a head judge.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['run_id']) && isset($_POST['judge_id']) && isset($_POST['new_score'])) {
    $stmt = $pdo->prepare("UPDATE scores SET score_value = ? WHERE run_id = ? AND judge_id = ?");
    $stmt->execute([$_POST['new_score'], $_POST['run_id'], $_POST['judge_id']]);
    echo "Score updated.";
    exit;
}

$runs = $pdo->query("
    SELECT s.id AS score_id, r.id AS run_id, e.name AS event_name, p.first_name, p.last_name, s.judge_id, s.score_value
    FROM scores s
    JOIN runs r ON s.run_id = r.id
    JOIN event_participants ep ON r.event_participant_id = ep.id
    JOIN participants p ON ep.participant_id = p.id
    JOIN events e ON ep.event_id = e.id
    ORDER BY r.id DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html><head><title>Head Judge Override</title></head><body>
<h2>Override Scores</h2>
<table border='1'><tr><th>Event</th><th>Participant</th><th>Judge</th><th>Current Score</th><th>New Score</th><th>Action</th></tr>
<?php foreach ($runs as $r): ?>
<tr>
<td><?= htmlspecialchars($r['event_name']) ?></td>
<td><?= htmlspecialchars($r['first_name'] . ' ' . $r['last_name']) ?></td>
<td>Judge <?= $r['judge_id'] ?></td>
<td><?= $r['score_value'] ?></td>
<td>
<form method="POST">
    <input type="hidden" name="run_id" value="<?= $r['run_id'] ?>">
    <input type="hidden" name="judge_id" value="<?= $r['judge_id'] ?>">
    <input type="number" name="new_score" min="0" max="99">
    <button type="submit">Update</button>
</form>
</td>
</tr>
<?php endforeach; ?>
</table>
</body></html>