<?php
session_start();
include 'includes/db.php';

$selected_event = $_GET['event_id'] ?? 0;
$filter_category = $_GET['category'] ?? 'all';
$filter_gender = $_GET['gender'] ?? 'all';

$events = $pdo->query("SELECT id, name FROM events ORDER BY date DESC")->fetchAll(PDO::FETCH_ASSOC);
$categories = $pdo->query("SELECT DISTINCT category FROM participants ORDER BY category")->fetchAll(PDO::FETCH_COLUMN);

$summary_data = [];
$heat_numbers = [];
if ($selected_event) {
    $sql = "
        SELECT
            p.category,
            p.bip,
            p.first_name,
            p.last_name,
            p.gender,
            ep.heat_number,
            r.run_number,
            AVG(s.score_value) as avg_score
        FROM runs r
        JOIN event_participants ep ON r.event_participant_id = ep.id
        JOIN participants p ON ep.participant_id = p.id
        LEFT JOIN scores s ON r.id = s.run_id
        WHERE ep.event_id = ?
        GROUP BY p.id, ep.heat_number, r.run_number
        ORDER BY p.category, ep.heat_number, r.run_number
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$selected_event]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($rows as $row) {
        if ($filter_gender !== 'all' && $row['gender'] !== $filter_gender) {
            continue;
        }

        $cat = $row['category'];
        $key = "{$row['bip']} - {$row['first_name']} {$row['last_name']}";
        $summary_data[$cat][$key]['gender'] = $row['gender'];
        $summary_data[$cat][$key]["H{$row['heat_number']}R{$row['run_number']}"] = number_format($row['avg_score'], 2);
        $heat_numbers["H{$row['heat_number']}R{$row['run_number']}"] = true;
    }
}
$headers = array_keys($heat_numbers);
sort($headers);
?>
<!DOCTYPE html>
<html>
<head>
    <title>View 3 - Summary Per Participant</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4 bg-light">
<div class="container">
    <h2>View 3: Summary Table</h2>
    <form method="get" class="row g-3 mb-4">
        <div class="col-md-4">
            <label>Select Event</label>
            <select name="event_id" class="form-select" onchange="this.form.submit()">
                <option value="">-- Choose Event --</option>
                <?php foreach ($events as $ev): ?>
                    <option value="<?= $ev['id'] ?>" <?= $selected_event == $ev['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($ev['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4">
            <label>Filter by Category</label>
            <select name="category" class="form-select" onchange="this.form.submit()">
                <option value="all">All Categories</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat ?>" <?= $filter_category == $cat ? 'selected' : '' ?>><?= $cat ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4">
            <label>Filter by Gender</label>
            <select name="gender" class="form-select" onchange="this.form.submit()">
                <option value="all" <?= $filter_gender == 'all' ? 'selected' : '' ?>>All</option>
                <option value="M" <?= $filter_gender == 'M' ? 'selected' : '' ?>>Male</option>
                <option value="F" <?= $filter_gender == 'F' ? 'selected' : '' ?>>Female</option>
                <option value="OPEN" <?= $filter_gender == 'OPEN' ? 'selected' : '' ?>>Open</option>
            </select>
        </div>
    </form>

    <?php foreach ($summary_data as $category => $participants): ?>
        <?php if ($filter_category === 'all' || $filter_category === $category): ?>
            <h4 class="mt-4"><?= htmlspecialchars($category) ?></h4>
            <table class="table table-bordered bg-white">
                <thead>
                    <tr><th>Participant</th><th>Gender</th>
                    <?php foreach ($headers as $h): ?><th><?= $h ?></th><?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($participants as $name => $runs): ?>
                    <tr>
                        <td><?= $name ?></td>
                        <td><?= $runs['gender'] ?? '-' ?></td>
                        <?php foreach ($headers as $h): ?>
                            <td><?= $runs[$h] ?? '-' ?></td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    <?php endforeach; ?>
</div>
</body>
</html>
