<?php
include '../includes/auth.php';
include '../includes/db.php';

$id = intval($_GET['id']);
$message = '';

$participant = $pdo->prepare("SELECT * FROM participants WHERE id = ?");
$participant->execute([$id]);
$p = $participant->fetch(PDO::FETCH_ASSOC);

if (!$p) {
    die('Participant not found.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("UPDATE participants SET
        bip=?, first_name=?, last_name=?, gender=?, fis_code=?, licence_code=?, licence_type=?,
        club=?, country=?, date_of_birth=?, category=? WHERE id=?");

    $date_of_birth = !empty($_POST['date_of_birth']) ? date('Y-m-d', strtotime($_POST['date_of_birth'])) : null;

    $stmt->execute([
        $_POST['bip'], $_POST['first_name'], $_POST['last_name'], $_POST['gender'],
        $_POST['fis_code'], $_POST['licence_code'], $_POST['licence_type'],
        $_POST['club'], $_POST['country'], $date_of_birth, $_POST['category'], $id
    ]);

    header("Location: participants.php?success=1");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Participant</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Edit Participant</h2>
    <form method="post">
        <?php foreach ($p as $field => $value): if ($field === 'id') continue; ?>
        <div class="mb-2">
            <label class="form-label"><?= ucwords(str_replace('_', ' ', $field)) ?></label>
            <input type="<?= $field === 'date_of_birth' ? 'date' : 'text' ?>" name="<?= $field ?>" class="form-control"
                value="<?= htmlspecialchars($value) ?>">
        </div>
        <?php endforeach; ?>
        <button type="submit" class="btn btn-primary">Save</button>
        <a href="participants.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
</body>
</html>
