<?php
include '../includes/auth.php';
include '../includes/db.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $event_id = $_POST['event_id'];
    $judge_ids = $_POST['judge_ids'] ?? [];

    // Remove existing assignments
    $delete_stmt = $pdo->prepare("DELETE FROM judge_assignments WHERE event_id = ?");
    $delete_stmt->execute([$event_id]);

    // Insert new assignments
    $insert_stmt = $pdo->prepare("INSERT INTO judge_assignments (event_id, judge_id) VALUES (?, ?)");
    foreach ($judge_ids as $jid) {
        $insert_stmt->execute([$event_id, $jid]);
    }

    $message = '<div class="alert alert-success">Judges assigned successfully.</div>';
}

$events = $pdo->query("SELECT * FROM events ORDER BY date DESC")->fetchAll(PDO::FETCH_ASSOC);
$judges = $pdo->query("SELECT * FROM judges ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// Preload current assignments if event is selected
$assigned_judges = [];
if (isset($_POST['event_id'])) {
    $eid = $_POST['event_id'];
    $stmt = $pdo->prepare("SELECT judge_id FROM judge_assignments WHERE event_id = ?");
    $stmt->execute([$eid]);
    $assigned_judges = array_column($stmt->fetchAll(PDO::FETCH_ASSOC), 'judge_id');
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Assign Judges to Events</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Assign Judges to Event</h2>
    <?php echo $message; ?>
    <form method="post">
        <div class="mb-3">
            <label class="form-label">Select Event</label>
            <select class="form-select" name="event_id" onchange="this.form.submit()" required>
                <option value="">-- Select Event --</option>
                <?php foreach ($events as $e): ?>
                    <option value="<?= $e['id'] ?>" <?= isset($_POST['event_id']) && $_POST['event_id'] == $e['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($e['name']) ?> (<?= $e['date'] ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <?php if (isset($_POST['event_id'])): ?>
        <h5>Select Judges:</h5>
        <?php foreach ($judges as $j): ?>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="judge_ids[]" value="<?= $j['id'] ?>"
                       <?= in_array($j['id'], $assigned_judges) ? 'checked' : '' ?>>
                <label class="form-check-label">
                    <?= htmlspecialchars($j['name']) ?> <?= $j['is_head'] ? '(Head)' : '' ?>
                </label>
            </div>
        <?php endforeach; ?>
        <button type="submit" class="btn btn-primary mt-3">Save Assignments</button>
        <?php endif; ?>
    </form>
</div>
</body>
</html>
