document.addEventListener('DOMContentLoaded', function () {
    const table = document.querySelector("table tbody");
    let draggedRow = null;

    table.querySelectorAll("tr").forEach(row => {
        const isLocked = row.querySelector(".locked-bip");
        if (isLocked) return;

        row.setAttribute("draggable", "true");

        row.addEventListener("dragstart", function (e) {
            draggedRow = this;
            this.style.opacity = 0.5;
        });

        row.addEventListener("dragover", function (e) {
            e.preventDefault();
        });

        row.addEventListener("drop", function (e) {
            e.preventDefault();
            if (draggedRow !== this) {
                const sibling = (this.compareDocumentPosition(draggedRow) & Node.DOCUMENT_POSITION_FOLLOWING)
                    ? this.nextSibling : this;
                table.insertBefore(draggedRow, sibling);
                updateOrderNumbers();
                saveNewOrder();
            }
        });

        row.addEventListener("dragend", function () {
            this.style.opacity = 1;
        });
    });

    function updateOrderNumbers() {
        table.querySelectorAll("tr").forEach((row, idx) => {
            const span = row.querySelector(".order-number");
            if (span) span.innerText = idx + 1;
        });
    }

    function saveNewOrder() {
        const ids = Array.from(table.querySelectorAll("tr")).map(row => row.dataset.id);
        fetch("save_sort_order.php", {
            method: "POST",
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ order: ids })
        }).then(res => res.json()).then(data => {
            if (!data.success) alert("Order save failed.");
        }).catch(err => console.error(err));
    }
});