<?php
include '../includes/auth.php';
include '../includes/db.php';

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $date = $_POST['date'];
    $location = $_POST['location'];
    $scoring_mode = $_POST['scoring_mode'];
    $runs_per_heat = $_POST['runs_per_heat'];
    $heats_total = $_POST['heats_total'];

    $stmt = $pdo->prepare("INSERT INTO events (name, date, location, scoring_mode, runs_per_heat, heats_total)
                           VALUES (?, ?, ?, ?, ?, ?)");
    if ($stmt->execute([$name, $date, $location, $scoring_mode, $runs_per_heat, $heats_total])) {
        $message = '<div class="alert alert-success">Event created successfully!</div>';
    } else {
        $message = '<div class="alert alert-danger">Failed to create event.</div>';
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Create Event</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Create Event</h2>
    <?php echo $message; ?>
    <form method="post">
        <div class="mb-3">
            <label class="form-label">Event Name</label>
            <input type="text" class="form-control" name="name" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Date</label>
            <input type="date" class="form-control" name="date" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Location</label>
            <input type="text" class="form-control" name="location" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Scoring Mode</label>
            <select class="form-select" name="scoring_mode">
                <option value="average">Average</option>
                <option value="best">Best</option>
                <option value="total">Total</option>
            </select>
        </div>
        <div class="mb-3">
            <label class="form-label">Runs Per Heat</label>
            <input type="number" class="form-control" name="runs_per_heat" value="2" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Total Heats</label>
            <input type="number" class="form-control" name="heats_total" value="1" required>
        </div>
        <button type="submit" class="btn btn-success">Create Event</button>
    </form>
</div>
</body>
</html>
