<?php
require_once 'includes/config.php';

echo "<h2>Quick Table Structure Check</h2>";

try {
    $pdo = new PDO($dsn, $username, $password, $options);
    
    echo "<h3>Figure Categories Table Columns:</h3>";
    $stmt = $pdo->query("SHOW COLUMNS FROM figure_categories");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($columns as $col) {
        echo $col['Field'] . " (" . $col['Type'] . ")<br>";
    }
    
    echo "<h3>Figure Items Table Columns:</h3>";
    $stmt = $pdo->query("SHOW COLUMNS FROM figure_items");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($columns as $col) {
        echo $col['Field'] . " (" . $col['Type'] . ")<br>";
    }
    
    echo "<h3>Sample Figure Categories Data:</h3>";
    $stmt = $pdo->query("SELECT * FROM figure_categories LIMIT 5");
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>" . print_r($categories, true) . "</pre>";
    
    echo "<h3>Sample Figure Items Data:</h3>";
    $stmt = $pdo->query("SELECT * FROM figure_items LIMIT 5");
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>" . print_r($items, true) . "</pre>";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
