<?php
// Quick test to see styling output
include 'includes/db.php';

$event_id = $_GET['event_id'] ?? 6; // Change this to your event ID

echo "<h1>Test Styling Output for Event ID: $event_id</h1>";

// Check what's in the database
$stmt = $pdo->prepare("SELECT * FROM result_styling WHERE event_id = ? AND config_id IS NULL");
$stmt->execute([$event_id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    echo "<p style='color: red;'>NO STYLING FOUND in database for event $event_id</p>";
    exit;
}

echo "<h2>✓ Found styling in database</h2>";
$styling = json_decode($row['styling_data'], true);

echo "<h3>Styling Data:</h3>";
echo "<pre>" . print_r($styling, true) . "</pre>";

// Get event info
$stmt = $pdo->prepare("SELECT name, date, location FROM events WHERE id = ?");
$stmt->execute([$event_id]);
$event = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<h3>Event Info:</h3>";
echo "<pre>" . print_r($event, true) . "</pre>";

// Test the header/footer generation (same code from summary_table_api.php)
function getAbsoluteLogoUrl($logo_url) {
    if (!$logo_url) return '';
    $logo_url = preg_replace('#^\.\./#', '', $logo_url);
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    return $protocol . '://' . $host . '/v2/' . ltrim($logo_url, '/');
}

$logo_sizes = ['small' => '50px', 'medium' => '80px', 'large' => '120px'];
$logo_size = $logo_sizes[$styling['logo_size'] ?? 'medium'] ?? '80px';
$logo_url = getAbsoluteLogoUrl($styling['logo_url'] ?? '');
$logo_position = $styling['logo_position'] ?? 'left';

echo "<h2>Logo Info:</h2>";
echo "<p>Logo URL: " . htmlspecialchars($styling['logo_url'] ?? 'NONE') . "</p>";
echo "<p>Absolute URL: " . htmlspecialchars($logo_url) . "</p>";
echo "<p>Logo Size: $logo_size</p>";

// Build header
$header_html = '<div class="results-header" style="margin-bottom: 20px; border-bottom: 2px solid ' . htmlspecialchars($styling['primary_color'] ?? '#0d6efd') . '; padding-bottom: 15px;">';
$header_html .= '<table width="100%" style="margin-bottom: 0;"><tr>';

if ($logo_url && $logo_position === 'left') {
    $header_html .= '<td width="' . $logo_size . '" style="vertical-align: top;"><img src="' . htmlspecialchars($logo_url) . '" alt="Logo" style="max-height: ' . $logo_size . '; max-width: ' . $logo_size . ';"></td>';
}

$header_html .= '<td style="vertical-align: top; padding-left: 15px;">';
if ($logo_url && $logo_position === 'center') {
    $header_html .= '<div style="text-align: center; margin-bottom: 10px;"><img src="' . htmlspecialchars($logo_url) . '" alt="Logo" style="max-height: ' . $logo_size . ';"></div>';
}
$header_html .= '<div>' . ($styling['header_content'] ?? '') . '</div>';
if ($styling['show_event_info'] ?? true) {
    $header_html .= '<div style="color: ' . htmlspecialchars($styling['secondary_color'] ?? '#6c757d') . '; margin-top: 5px;">';
    $header_html .= '<strong>' . htmlspecialchars($event['name']) . '</strong>, ';
    $header_html .= date('F d, Y', strtotime($event['date'])) . ', ';
    $header_html .= htmlspecialchars($event['location']);
    $header_html .= '</div>';
}
$header_html .= '</td>';

if ($logo_url && $logo_position === 'right') {
    $header_html .= '<td width="' . $logo_size . '" style="vertical-align: top; text-align: right;"><img src="' . htmlspecialchars($logo_url) . '" alt="Logo" style="max-height: ' . $logo_size . '; max-width: ' . $logo_size . ';"></td>';
}

$header_html .= '</tr></table></div>';

// Build footer
$footer_html = '<div class="results-footer" style="margin-top: 20px; border-top: 1px solid ' . htmlspecialchars($styling['secondary_color'] ?? '#6c757d') . '; padding-top: 10px;">';
$footer_html .= '<div>' . ($styling['footer_content'] ?? '') . '</div>';
if ($styling['show_generation_date'] ?? true) {
    $footer_html .= '<div style="font-size: 0.9em; color: #666; margin-top: 5px;">Generated on ' . date('F d, Y \a\t H:i') . ' | StyleScore.com Results System</div>';
}
$footer_html .= '</div>';

echo "<hr>";
echo "<h2>RENDERED HEADER:</h2>";
echo "<div style='border: 3px solid green; padding: 20px; background: white;'>";
echo $header_html;
echo "</div>";

echo "<hr>";
echo "<h2>RENDERED FOOTER:</h2>";
echo "<div style='border: 3px solid blue; padding: 20px; background: white;'>";
echo $footer_html;
echo "</div>";

echo "<hr>";
echo "<h2>Test API Links:</h2>";
echo "<p><a href='/v2/api/summary_table_api.php?event_id=$event_id&category=all&format=html&stylesheet=yes' target='_blank'>View Summary Table HTML</a></p>";
echo "<p><a href='/v2/api/summary_table_api.php?event_id=$event_id&category=all&format=pdf&stylesheet=yes' target='_blank'>View Summary Table PDF</a></p>";
