<?php
// Test if results_styling.php getStyledHeaderFooter function works directly
include 'includes/db.php';
include 'includes/config.php';

// Define helper functions if not already defined
if (!function_exists('getAbsoluteLogoUrl')) {
    function getAbsoluteLogoUrl($logo_url) {
        if (!$logo_url) return '';
        $logo_url = preg_replace('#^\.\./#', '', $logo_url);
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'];
        return $protocol . '://' . $host . '/v2/' . ltrim($logo_url, '/');
    }
}

if (!function_exists('pt_to_em')) {
    function pt_to_em($pt, $base_pt = 12) {
        return $pt / $base_pt;
    }
}

// Include results_styling.php to get the function
include 'admin/results_styling.php';

// Test with event ID 3 (or whatever event you have styling configured for)
$event_id = 3;
$config_id = null;

echo "<h1>Testing getStyledHeaderFooter Function</h1>";
echo "<hr>";

try {
    $result = getStyledHeaderFooter($pdo, $event_id, $config_id);
    
    echo "<h2>Function returned successfully!</h2>";
    echo "<h3>Keys in result:</h3>";
    echo "<pre>" . print_r(array_keys($result), true) . "</pre>";
    
    echo "<h3>Header HTML (first 500 chars):</h3>";
    echo "<pre>" . htmlspecialchars(substr($result['header_html'] ?? 'MISSING', 0, 500)) . "</pre>";
    
    echo "<h3>Footer HTML (first 500 chars):</h3>";
    echo "<pre>" . htmlspecialchars(substr($result['footer_html'] ?? 'MISSING', 0, 500)) . "</pre>";
    
    echo "<hr>";
    echo "<h3>Full Header HTML Rendered:</h3>";
    echo "<div style='border: 2px solid blue; padding: 10px;'>";
    echo $result['header_html'];
    echo "</div>";
    
    echo "<h3>Full Footer HTML Rendered:</h3>";
    echo "<div style='border: 2px solid green; padding: 10px;'>";
    echo $result['footer_html'];
    echo "</div>";
    
} catch (Exception $e) {
    echo "<h2 style='color: red;'>ERROR:</h2>";
    echo "<pre>" . $e->getMessage() . "</pre>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
