<?php
require_once 'includes/db.php';
require_once 'includes/ScoringLayoutConfig.php';

echo "<h2>Scoring Layout Configuration Status</h2>";

// Check if we have any configurations
$stmt = $pdo->query("SELECT * FROM scoring_layout_configs");
$configs = $stmt->fetchAll();

echo "<h3>Saved Configurations (" . count($configs) . "):</h3>";
if (empty($configs)) {
    echo "<p>No saved configurations found.</p>";
} else {
    echo "<table border='1'>";
    echo "<tr><th>Event ID</th><th>Heat Number</th><th>Configuration</th></tr>";
    foreach ($configs as $config) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($config['event_id']) . "</td>";
        echo "<td>" . htmlspecialchars($config['heat_number'] ?? 'ALL') . "</td>";
        echo "<td>" . substr(htmlspecialchars($config['configuration']), 0, 100) . "...</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Test the ScoringLayoutConfig class
echo "<h3>Available Components:</h3>";
$components = ScoringLayoutConfig::getAvailableComponents();
echo "<ul>";
foreach ($components as $key => $component) {
    echo "<li><strong>$key</strong>: {$component['title']} (selector: {$component['selector']})</li>";
}
echo "</ul>";

// Test generating a sample configuration script
echo "<h3>Sample Configuration Script:</h3>";
$sampleConfig = [
    'criteriaInputGrid' => false,
    'finalCalculatedScore' => true,
    'figuresCard' => true,
    'latestScores' => false
];

try {
    $script = ScoringLayoutConfig::generateApplyScript($sampleConfig);
    echo "<textarea style='width:100%; height:200px;'>" . htmlspecialchars($script) . "</textarea>";
} catch (Exception $e) {
    echo "<p style='color:red;'>Error generating script: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>