<?php
require_once 'includes/db.php';

// Test the layout configuration mapping
$event_id = 3; // Use event 3 which has the nested config

try {
    $layout_stmt = $pdo->prepare("SELECT scoring_layout_config FROM events WHERE id = ?");
    $layout_stmt->execute([$event_id]);
    $layout_config_json = $layout_stmt->fetchColumn();
    
    echo "<h2>Raw JSON from database:</h2>";
    echo "<pre>" . htmlspecialchars($layout_config_json) . "</pre>";
    
    if ($layout_config_json) {
        $raw_config = json_decode($layout_config_json, true);
        
        echo "<h2>Parsed raw config:</h2>";
        echo "<pre>" . print_r($raw_config, true) . "</pre>";
        
        // Convert nested structure to flat structure with proper component names
        $scoring_layout_config = [];
        
        if (isset($raw_config['cards']) && is_array($raw_config['cards'])) {
            $component_mapping = [
                'formatInfo' => 'format-info',
                'participantSelection' => 'participant-selection', 
                'otherHeatScores' => 'other-heat-scores',
                'criteriaInputGrid' => 'criteria-input-grid',
                'finalCalculatedScore' => 'final-calculated-score',
                'figuresCard' => 'figures-card',
                'diversityValidation' => 'diversity-validation',
                'latestScores' => 'latest-scores',
                'figureHistory' => 'figure-history',
                'submitButton' => 'submit-button'
            ];
            
            foreach ($raw_config['cards'] as $camelCase => $config) {
                if (isset($component_mapping[$camelCase]) && isset($config['enabled'])) {
                    $kebabCase = $component_mapping[$camelCase];
                    $scoring_layout_config[$kebabCase] = (bool)$config['enabled'];
                }
            }
        }
        
        echo "<h2>Final mapped config:</h2>";
        echo "<pre>" . print_r($scoring_layout_config, true) . "</pre>";
        
        // Test the component checks
        echo "<h2>Component visibility tests:</h2>";
        $components = [
            'format-info',
            'participant-selection',
            'other-heat-scores', 
            'criteria-input-grid',
            'final-calculated-score',
            'figures-card',
            'diversity-validation',
            'latest-scores',
            'figure-history',
            'submit-button'
        ];
        
        foreach ($components as $component) {
            $should_show = !$scoring_layout_config || ($scoring_layout_config[$component] ?? true);
            $status = $should_show ? 'SHOW' : 'HIDE';
            $config_value = isset($scoring_layout_config[$component]) ? ($scoring_layout_config[$component] ? 'true' : 'false') : 'not_set';
            echo "<div>$component: <strong>$status</strong> (config: $config_value)</div>";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>