<?php
include 'includes/db.php';

echo "<h1>Scoring Layout Configurations Test</h1>";

// Get all configurations
$stmt = $pdo->query('SELECT * FROM scoring_layout_configs ORDER BY event_id');
$configs = $stmt->fetchAll();

echo "<h2>Current Configurations:</h2>";
foreach ($configs as $config) {
    echo "<h3>Event " . $config['event_id'] . " (Heat: " . ($config['heat_number'] ?: 'All') . ")</h3>";
    echo "<pre>" . json_encode(json_decode($config['config_json']), JSON_PRETTY_PRINT) . "</pre>";
    echo "<hr>";
}

echo "<h2>Test Configuration Loading:</h2>";

include 'includes/ScoringLayoutConfig.php';

foreach ([1, 3] as $event_id) {
    echo "<h3>Event $event_id Configuration Test:</h3>";
    $config = ScoringLayoutConfig::getEffectiveConfig($event_id, 1, $pdo);
    echo "<p><strong>Effective Config:</strong></p>";
    echo "<pre>" . json_encode($config, JSON_PRETTY_PRINT) . "</pre>";
    
    echo "<p><strong>Generated JavaScript:</strong></p>";
    echo "<pre>" . htmlspecialchars(ScoringLayoutConfig::generateApplyScript($config)) . "</pre>";
    echo "<hr>";
}
?>