<?php
/**
 * Test Judge Status API
 * This script tests the judge status API endpoints
 */

echo "=== Judge Status API Test ===\n\n";

// Test configuration
$base_url = 'http://localhost/v2/api/judge_status_api.php';
$test_event_id = 6; // Change to your test event ID
$test_judge_id = 1; // Change to your test judge ID

echo "Testing with Event ID: $test_event_id, Judge ID: $test_judge_id\n\n";

// Test 1: Update judge status to 'ready'
echo "TEST 1: Update judge status to 'ready'\n";
$data = [
    'event_id' => $test_event_id,
    'judge_id' => $test_judge_id,
    'status' => 'ready',
    'timestamp' => date('Y-m-d H:i:s')
];

$options = [
    'http' => [
        'header'  => "Content-Type: application/json\r\n",
        'method'  => 'POST',
        'content' => json_encode($data)
    ]
];
$context  = stream_context_create($options);
$response = file_get_contents($base_url, false, $context);

echo "Raw response: " . $response . "\n";
$result = json_decode($response, true);
echo "Response: " . json_encode($result, JSON_PRETTY_PRINT) . "\n\n";

// Test 2: Update judge status to 'warning'
echo "TEST 2: Update judge status to 'warning'\n";
$data['status'] = 'warning';

$ch = curl_init($base_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
curl_close($ch);

$result = json_decode($response, true);
echo "Response: " . json_encode($result, JSON_PRETTY_PRINT) . "\n\n";

// Test 3: Get specific judge status
echo "TEST 3: Get specific judge status\n";
$url = $base_url . "?event_id=$test_event_id&judge_id=$test_judge_id";
$response = file_get_contents($url);
$result = json_decode($response, true);
echo "Response: " . json_encode($result, JSON_PRETTY_PRINT) . "\n\n";

// Test 4: Get all judge statuses for event
echo "TEST 4: Get all judge statuses for event\n";
$url = $base_url . "?event_id=$test_event_id";
$response = file_get_contents($url);
$result = json_decode($response, true);
echo "Response: " . json_encode($result, JSON_PRETTY_PRINT) . "\n\n";

// Test 5: Test invalid status
echo "TEST 5: Test invalid status (should fail)\n";
$data['status'] = 'invalid_status';

$ch = curl_init($base_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
curl_close($ch);

$result = json_decode($response, true);
echo "Response: " . json_encode($result, JSON_PRETTY_PRINT) . "\n\n";

echo "=== Tests Completed ===\n";
